/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.internal.lua;

import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class ReadOnlyLuaTable
extends LuaTable {
    private static final String READONLY = "For cross-script security, string metatables are read-only.";

    public ReadOnlyLuaTable(LuaValue table) {
        this.presize(table.length(), 0);
        Varargs n = table.next(LuaValue.NIL);
        while (!n.arg1().isnil()) {
            LuaValue key = n.arg1();
            LuaValue value = n.arg(2);
            super.rawset(key, (LuaValue)(value.istable() ? new ReadOnlyLuaTable(value) : value));
            n = table.next(n.arg1());
        }
    }

    public LuaValue setmetatable(LuaValue metatable) {
        return ReadOnlyLuaTable.error((String)READONLY);
    }

    public void set(int key, LuaValue value) {
        ReadOnlyLuaTable.error((String)READONLY);
    }

    public void rawset(int key, LuaValue value) {
        ReadOnlyLuaTable.error((String)READONLY);
    }

    public void rawset(LuaValue key, LuaValue value) {
        ReadOnlyLuaTable.error((String)READONLY);
    }

    public LuaValue remove(int pos) {
        return ReadOnlyLuaTable.error((String)READONLY);
    }
}

