/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.splitter;

import com.silabs.pti.splitter.ISplitter;
import com.silabs.pti.util.ICharacterListener;
import com.silabs.pti.util.ICharacterMatcher;

public class BracketSplitter
implements ISplitter {
    private final ICharacterListener[] buckets = new ICharacterListener[this.bucketCount()];
    private boolean insideBrackets = false;
    private final ICharacterMatcher openBracket;
    private final ICharacterMatcher closeBracket;
    private final byte[] stack;
    private int stackSize = 0;

    public BracketSplitter(ICharacterMatcher openBracket, ICharacterMatcher closeBracket) {
        this.stack = new byte[Math.max(openBracket.length(), closeBracket.length())];
        this.stackSize = 0;
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
    }

    @Override
    public void setCharacterListener(int bucket, ICharacterListener l) {
        this.buckets[bucket] = l;
    }

    @Override
    public int bucketCount() {
        return 2;
    }

    @Override
    public void received(byte[] input, int offset, int len) {
        int startIndex = offset;
        int count = 0;
        for (int i = offset; i < offset + len; ++i) {
            int currentTarget;
            byte c = input[i];
            ICharacterMatcher expectedBracket = this.insideBrackets ? this.closeBracket : this.openBracket;
            int n = currentTarget = this.insideBrackets ? 1 : 0;
            if (expectedBracket.isByteAt(this.stackSize, c)) {
                this.stack[this.stackSize++] = c;
                if (this.stackSize != expectedBracket.length()) continue;
                if (count > 0) {
                    this.buckets[currentTarget].received(input, startIndex, count);
                }
                startIndex = i + 1;
                count = 0;
                this.insideBrackets = !this.insideBrackets;
                this.buckets[1].received(this.stack, 0, this.stackSize);
                this.stackSize = 0;
                continue;
            }
            count += this.stackSize + 1;
            this.stackSize = 0;
        }
        if (count > 0) {
            this.buckets[this.insideBrackets ? 1 : 0].received(input, startIndex, count);
        }
    }

    @Override
    public void flush() {
        if (this.stackSize > 0) {
            this.buckets[this.insideBrackets ? 1 : 0].received(this.stack, 0, this.stackSize);
            this.stackSize = 0;
        }
        this.insideBrackets = false;
    }
}

