/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.format;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.decode.AemDecoder;
import com.silabs.pti.decode.AemSample;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.format.PrintStreamOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class AemFileFormat
implements IDebugChannelExportFormat<PrintStream> {
    @Override
    public IDebugChannelExportOutput<PrintStream> createOutput(File f, boolean append) throws IOException {
        return new PrintStreamOutput(f, append);
    }

    @Override
    public IDebugChannelExportOutput<PrintStream> createStdoutOutput() {
        return new PrintStreamOutput(System.out);
    }

    @Override
    public void writeHeader(PrintStream out) throws IOException {
        out.println("#     Time    Voltage    Current");
    }

    @Override
    public String description() {
        return "All packets but AEM data are ignored, and AEM data is written as data file, with time, voltage and current in each line.";
    }

    @Override
    public boolean isUsingRawBytes() {
        return false;
    }

    @Override
    public boolean isUsingDebugMessages() {
        return true;
    }

    @Override
    public boolean formatDebugMessage(PrintStream outWriter, String originator, DebugMessage dm, EventType type) throws IOException {
        AemSample as;
        if (!type.isAem()) {
            return false;
        }
        long microSecondTime = dm.networkTime();
        byte[] contents = dm.contents();
        AemDecoder ad = new AemDecoder(microSecondTime, contents);
        StringBuilder sb = new StringBuilder();
        String sep = "";
        while ((as = ad.nextSample()) != null) {
            sb.append(String.format("%s%10d %10f %10f", sep, as.timestamp(), Float.valueOf(as.voltage()), Float.valueOf(as.current())));
            sep = "\n";
        }
        outWriter.println(sb.toString());
        return true;
    }

    @Override
    public boolean formatRawBytes(PrintStream out, long pcTimeMs, byte[] rawBytes, int offset, int length) {
        return false;
    }

    @Override
    public void writeRawUnframedData(PrintStream out, byte[] rawBytes, int offset, int length) throws IOException {
    }
}

