/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.decode;

import com.silabs.na.pcap.util.ByteArrayUtil;
import com.silabs.pti.decode.AemField;
import com.silabs.pti.decode.AemSample;
import com.silabs.pti.util.MiscUtil;

public class AemDecoder {
    private final long time;
    private final byte[] contents;
    private int index;
    private int sampleCount = 0;
    private int sampleRate;
    private float voltage;

    public AemDecoder(long time, byte[] contents) {
        this.time = time;
        this.contents = contents;
    }

    private int decode(int length) {
        int offset = this.index;
        int val = ByteArrayUtil.byteArrayToInt((byte[])this.contents, (int)offset, (int)length, (boolean)false);
        this.index += length;
        return val;
    }

    private float decodeFloat(int length) {
        float val = MiscUtil.byteArrayToFloat(this.contents, this.index, length, false).floatValue();
        this.index += length;
        return val;
    }

    private boolean notEnoughBytesLeft(int requiredBytes) {
        return this.contents.length < this.index + requiredBytes;
    }

    private AemSample firstSample() {
        this.index += AemField.version.length();
        if (this.notEnoughBytesLeft(AemField.sampleRate.length())) {
            return null;
        }
        this.sampleRate = this.decode(AemField.sampleRate.length());
        this.index += AemField.sampleBufferSize.length();
        this.index += AemField.sampleBufferSequenceNumber.length();
        this.index += AemField.reservedConfig.length();
        if (this.notEnoughBytesLeft(AemField.voltage.length())) {
            return null;
        }
        this.voltage = this.decodeFloat(AemField.voltage.length());
        this.index += AemField.reservedData.length();
        this.index += AemField.status.length();
        return this.subsequentSample();
    }

    private AemSample subsequentSample() {
        long sampleT = this.time + (long)(1000000 * this.sampleCount / this.sampleRate);
        if (this.notEnoughBytesLeft(AemField.current.length())) {
            return null;
        }
        float current = this.decodeFloat(AemField.current.length());
        ++this.sampleCount;
        return new AemSample(sampleT, current, this.voltage);
    }

    public AemSample nextSample() {
        if (this.index == 0) {
            return this.firstSample();
        }
        return this.subsequentSample();
    }
}

