/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.BinaryFramer;

public class DebugChannelFramer
extends BinaryFramer {
    private static final int READING_START = 0;
    private static final int READING_LENGTH_LSB = 1;
    private static final int READING_LENGTH_MSB = 2;
    private static final int READING_MESSAGE = 3;
    private static final int READING_END = 4;
    private static final int OPEN_BRACKET = 91;
    private static final int CLOSE_BRACKET = 93;
    private byte[] message;
    private int state = 0;
    private int index;
    private final int sizeError;
    private int lengthLSB = 0;
    private final boolean twoByteLength;

    public DebugChannelFramer(boolean twoByteLength) {
        this.twoByteLength = twoByteLength;
        this.sizeError = twoByteLength ? -2 : 5;
    }

    @Override
    public byte[] assembleMessage(byte nextByte) {
        switch (this.state) {
            case 0: {
                if (nextByte != 91) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (this.twoByteLength) {
                    this.lengthLSB = nextByte & 0xFF;
                    this.state = 2;
                    break;
                }
                this.message = new byte[(nextByte & 0xFF) + this.sizeError];
                this.index = 0;
                this.state = 3;
                break;
            }
            case 2: {
                this.message = new byte[((nextByte & 0xFF) << 8) + this.lengthLSB + this.sizeError];
                this.index = 0;
                this.state = 3;
                break;
            }
            case 3: {
                this.message[this.index] = nextByte;
                ++this.index;
                if (this.index != this.message.length) break;
                this.state = 4;
                break;
            }
            case 4: {
                this.state = 0;
                if (nextByte == 93) {
                    return this.message;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    @Override
    public byte[] flushMessage() {
        switch (this.state) {
            case 3: 
            case 4: {
                this.state = 0;
                return this.message;
            }
        }
        this.state = 0;
        return null;
    }

    @Override
    public byte[] frame(byte[] msg) {
        int extra = this.twoByteLength ? 1 : 0;
        byte[] temp = new byte[msg.length + 3 + extra];
        temp[0] = 91;
        temp[1] = (byte)(msg.length - this.sizeError);
        temp[2] = (byte)(msg.length - this.sizeError >> 8);
        System.arraycopy(msg, 0, temp, 2 + extra, msg.length);
        temp[msg.length + 2 + extra] = 93;
        return temp;
    }
}

