/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.log.PtiSeverity;

public class ConnectivityStats {
    private long lastPrintTime = 0L;
    private long startTime = Long.MIN_VALUE;
    private long totalBytes = 0L;
    private long totalCountedBytes = 0L;
    private int bitPerSecLifetime;
    private final IConnectivityLogger logger;
    private final String prefix;

    public ConnectivityStats(IConnectivityLogger logger, String prefix) {
        this.logger = logger;
        this.prefix = prefix;
    }

    public void recordData(long t, int count) {
        this.totalBytes += (long)count;
        if (this.startTime == Long.MIN_VALUE) {
            this.startTime = t;
        } else {
            this.totalCountedBytes += (long)count;
            int msElapsed = (int)(t - this.startTime);
            if (this.logger != null && this.logger.bpsRecordPeriodMs() > 0 && t - this.lastPrintTime > (long)this.logger.bpsRecordPeriodMs() && msElapsed > 0) {
                this.bitPerSecLifetime = (int)(8000L * this.totalCountedBytes / (long)msElapsed);
                this.logger.log(PtiSeverity.INFO, String.format("%s => %12d bytes / %8d ms = %10d kbit/s", this.prefix, this.totalBytes, msElapsed, this.bitPerSecLifetime / 1000), null);
                this.lastPrintTime = t;
            }
        }
    }
}

