/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.ISpecificOptionMapping;
import com.silabs.ss.framework.project.internal.core.model.options.BaseOptionMappingEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericSpecificOptionMappingEngine
extends BaseOptionMappingEngine<MGenericOption, IGenericOptionMapping, ISpecificOptionMapping> {
    public GenericSpecificOptionMappingEngine(IGenericOptionMappingRegistry mappings) {
        super(MGenericOption.class, mappings);
    }

    protected void updateSettingsSiteForImport(MSettingsSite settings, MSpecificOption spec, MGenericOption[] outs) {
        MGenericOption[] mGenericOptionArray = outs;
        int n = outs.length;
        int n2 = 0;
        while (n2 < n) {
            MGenericOption out = mGenericOptionArray[n2];
            spec.getGenericMappings().add((Object)out);
            ++n2;
        }
    }

    @Override
    protected boolean outgoingCoversIncoming(MGenericOption gen, MSpecificOption specific) {
        return gen.getSpecificMappings().contains((Object)specific);
    }

    @Override
    protected List<MGenericOption> gatherOutgoing(MSettingsSite site) {
        ArrayList<MGenericOption> genericOptionList = null;
        for (MConvertedOption cvt : site.getConvertedOptions()) {
            if (cvt instanceof MSpecificOption) {
                MSpecificOption spec = (MSpecificOption)cvt;
                if (spec.getGenericMappings().isEmpty()) continue;
                if (genericOptionList == null) {
                    genericOptionList = new ArrayList();
                }
                genericOptionList.addAll((Collection<MGenericOption>)spec.getGenericMappings());
                continue;
            }
            if (cvt instanceof MGenericOption) {
                if (genericOptionList == null) {
                    genericOptionList = new ArrayList<MGenericOption>();
                }
                genericOptionList.add((MGenericOption)cvt);
                continue;
            }
            assert (false);
        }
        return genericOptionList == null ? Collections.emptyList() : genericOptionList;
    }

    @Override
    protected Map<String, MSpecificOption> gatherExistingSpecific(MSettingsSite site) {
        HashMap<String, MSpecificOption> specificOptionMap = new HashMap<String, MSpecificOption>();
        for (MConvertedOption cvt : site.getConvertedOptions()) {
            if (!(cvt instanceof MSpecificOption)) continue;
            MSpecificOption spec = (MSpecificOption)cvt;
            specificOptionMap.put(spec.getOptionId(), spec);
        }
        return specificOptionMap;
    }
}

