/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.silabs.java.utils.ArrayUtils;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IReverseOptionMapping;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseOptionMappingRegistry<OutgoingOption extends MConvertedOption, IncomingMapping extends IOptionMapping<OutgoingOption>, OutgoingMapping extends IReverseOptionMapping<OutgoingOption>>
implements IOptionMappingRegistry<OutgoingOption, IncomingMapping, OutgoingMapping> {
    private Map<IProperty, List<IncomingMapping>> genericMappings = new LinkedHashMap<IProperty, List<IncomingMapping>>();
    private List<OutgoingMapping> specificMappings = new ArrayList<OutgoingMapping>();
    private Class<IncomingMapping> incomingMappingClass;
    private Class<OutgoingMapping> outgoingMappingClass;

    public BaseOptionMappingRegistry(Class<IncomingMapping> incomingMappingClass, Class<OutgoingMapping> outgoingMappingClass) {
        this.incomingMappingClass = incomingMappingClass;
        this.outgoingMappingClass = outgoingMappingClass;
    }

    @Override
    public void registerOptionMapping(IncomingMapping mapping) {
        List<IncomingMapping> list = this.genericMappings.get(mapping.getIncomingOption());
        if (list == null) {
            list = new ArrayList<IncomingMapping>(1);
            this.genericMappings.put(mapping.getIncomingOption(), list);
        }
        list.add(mapping);
        this.specificMappings.add(this.createOutgoingMapping(mapping));
    }

    protected abstract OutgoingMapping createOutgoingMapping(IncomingMapping var1);

    @Override
    public IncomingMapping[] findOptionMappings(IProperty externalOption) {
        List<IncomingMapping> list = this.genericMappings.get(externalOption);
        if (list == null) {
            return null;
        }
        return (IOptionMapping[])ArrayUtils.toArray(this.incomingMappingClass, list);
    }

    @Override
    public OutgoingMapping[] findReverseOptionMappings(Collection<IProperty> genericOptions) {
        LinkedHashSet<IReverseOptionMapping> specifics = new LinkedHashSet<IReverseOptionMapping>(1);
        for (IReverseOptionMapping specific : this.specificMappings) {
            IProperty[] generics;
            IProperty[] iPropertyArray = generics = specific.getOutgoingOptions();
            int n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                IProperty generic = iPropertyArray[n2];
                if (genericOptions.contains(generic)) {
                    specifics.add(specific);
                }
                ++n2;
            }
        }
        return (IReverseOptionMapping[])ArrayUtils.toArray(this.outgoingMappingClass, specifics);
    }
}

