/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EValueStatus implements Enumerator
{
    UNKNOWN(-1, "UNKNOWN", "UNKNOWN"),
    KNOWN_DEFAULT(0, "KNOWN_DEFAULT", "KNOWN_DEFAULT"),
    KNOWN_CUSTOMIZED(1, "KNOWN_CUSTOMIZED", "KNOWN_CUSTOMIZED");

    public static final int UNKNOWN_VALUE = -1;
    public static final int KNOWN_DEFAULT_VALUE = 0;
    public static final int KNOWN_CUSTOMIZED_VALUE = 1;
    private static final EValueStatus[] VALUES_ARRAY;
    public static final List<EValueStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EValueStatus[]{UNKNOWN, KNOWN_DEFAULT, KNOWN_CUSTOMIZED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EValueStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EValueStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EValueStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EValueStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EValueStatus get(int value) {
        switch (value) {
            case -1: {
                return UNKNOWN;
            }
            case 0: {
                return KNOWN_DEFAULT;
            }
            case 1: {
                return KNOWN_CUSTOMIZED;
            }
        }
        return null;
    }

    private EValueStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

