/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EMappingStatus implements Enumerator
{
    UNMAPPED(0, "UNMAPPED", "UNMAPPED"),
    MAPPED(1, "MAPPED", "MAPPED"),
    PARTIALLY_MAPPED(-1, "PARTIALLY_MAPPED", "PARTIALLY_MAPPED");

    public static final int UNMAPPED_VALUE = 0;
    public static final int MAPPED_VALUE = 1;
    public static final int PARTIALLY_MAPPED_VALUE = -1;
    private static final EMappingStatus[] VALUES_ARRAY;
    public static final List<EMappingStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EMappingStatus[]{UNMAPPED, MAPPED, PARTIALLY_MAPPED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EMappingStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EMappingStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EMappingStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EMappingStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EMappingStatus get(int value) {
        switch (value) {
            case 0: {
                return UNMAPPED;
            }
            case 1: {
                return MAPPED;
            }
            case -1: {
                return PARTIALLY_MAPPED;
            }
        }
        return null;
    }

    private EMappingStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

