/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher;

import com.silabs.java.utils.log.Log;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.PrintWriter;
import java.nio.file.Path;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;
import slc.launcher.cli.CliLauncherArgs;
import slc.launcher.connection.ConnectionUtils;
import slc.launcher.context.SlcCliContext;
import slc.launcher.instrumented.JavaLauncherTelemetryUtils;
import slc.launcher.utils.ExecutionUtils;
import slc.launcher.utils.SlcDefaultLogger;

public class SlcCmdRunner {
    public SlcCmdRunner() {
        Thread loader = new Thread(ConnectionUtils::httpclient);
        loader.setDaemon(true);
        loader.start();
    }

    public int run(String[] args2) {
        Span launchItself = JavaLauncherTelemetryUtils.launcherCoreTracer().spanBuilder("java-launcher-execution").startSpan();
        try {
            Scope scope = launchItself.makeCurrent();
            try {
                SlcCmdRunner.setupAnsi(true);
                SlcDefaultLogger logger = SlcDefaultLogger.instance();
                Path workingDir = ExecutionUtils.defaultWorkingDirectory();
                SlcCliContext context = new SlcCliContext(workingDir, ExecutionUtils.executionHome(logger), logger);
                int exitCode = this.runCommand(args2, context);
                SlcCmdRunner.setupAnsi(false);
                int n = exitCode;
                if (scope != null) {
                    scope.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            launchItself.end();
        }
    }

    public int runCommand(String[] args2, SlcCliContext context) {
        return this.runCommand(args2, context, new CliLauncherArgs(context));
    }

    public int runCommand(String[] args2, SlcCliContext context, CliLauncherArgs runner) {
        Log.setLogger(context.logger().toLogger());
        CommandLine cmd = new CommandLine(runner);
        cmd.setUnmatchedArgumentsAllowed(true);
        cmd.setOut(new PrintWriter(context.logger().out()));
        cmd.setErr(new PrintWriter(context.logger().err()));
        int returnCode = cmd.execute(args2);
        if (runner.isRunningDebug()) {
            context.logger().out().println("Command execution ended with return code " + returnCode);
        }
        return returnCode;
    }

    private static void setupAnsi(boolean install) {
        try {
            if (install) {
                AnsiConsole.systemInstall();
            } else {
                AnsiConsole.systemUninstall();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

