/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.runtime.RuntimeUtils;
import java.io.File;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnvironmentVariableUtils {
    public static final String WIN_PATH_ENV_VAR = "Path";
    public static final String WIN_PATH_ENV_VAR_ALT = "PATH";
    public static final String OSX_LIB_ENV_VAR = "DYLD_LIBRARY_PATH";
    public static final String LINUX_LIB_ENV_VAR = "LD_LIBRARY_PATH";
    private static Function<String, String> environmentVariableAccessor = System::getenv;

    public static String getBuildsTestsValue(String envVarName) {
        String value;
        if (!TextUtils.isEmpty(envVarName) && (RuntimeUtils.isJUnitRunning() || RuntimeUtils.isHeadless() || RuntimeUtils.isPlatformPDELaunch()) && (value = System.getenv(envVarName)) != null) {
            return value;
        }
        return "";
    }

    public static String getDirectoryValue(String envVarName) {
        String value;
        if (!TextUtils.isBlank(envVarName) && FileUtils.isValidDirectory(value = System.getenv(envVarName))) {
            return value;
        }
        return null;
    }

    public static String validateMultiPaths(String pathValue) {
        if (TextUtils.isBlank(pathValue)) {
            return pathValue;
        }
        String[] paths = pathValue.split(File.pathSeparator);
        return Stream.of(paths).map(p -> {
            try {
                return new File((String)p).getCanonicalFile();
            }
            catch (Exception e) {
                Log.error(e);
                return null;
            }
        }).filter(Objects::nonNull).filter(File::isDirectory).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    public static String getOrDefault(String envVarName, String defaultValue) {
        String value = EnvironmentVariableUtils.getValue(envVarName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getValue(String envVarName) {
        if (!TextUtils.isBlank(envVarName)) {
            return environmentVariableAccessor.apply(envVarName);
        }
        return null;
    }

    public static void junitStubEnvAccessor(Function<String, String> alt) {
        if (alt == null) {
            alt = System::getenv;
        }
        environmentVariableAccessor = alt;
    }

    public static String getProcessWinPathName(ProcessBuilder pb) {
        String currentWinLibVal = pb.environment().get(WIN_PATH_ENV_VAR);
        return TextUtils.isEmpty(currentWinLibVal) ? WIN_PATH_ENV_VAR_ALT : WIN_PATH_ENV_VAR;
    }

    public static String getProcessWinPathVal(ProcessBuilder pb) {
        return pb.environment().get(EnvironmentVariableUtils.getProcessWinPathName(pb));
    }

    public static String getLibEnvVarName(ProcessBuilder pb) {
        String libEnvVarName = "";
        if (HostUtils.isWindows()) {
            libEnvVarName = EnvironmentVariableUtils.getProcessWinPathName(pb);
        } else if (HostUtils.isOSX()) {
            libEnvVarName = OSX_LIB_ENV_VAR;
        } else if (HostUtils.isLinux()) {
            libEnvVarName = LINUX_LIB_ENV_VAR;
        }
        return libEnvVarName;
    }
}

