/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.files.monitor;

import com.silabs.java.internal.utils.files.monitor.SingleDirectoryMonitor;
import com.silabs.java.utils.files.monitor.IDirectoryNotifier;
import com.silabs.java.utils.log.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DirectoryMonitor {
    public static final int MAX_DEPTH = Integer.MAX_VALUE;
    public static final int NON_RECURSIVE = 0;
    private final Path topDir;
    private final IDirectoryNotifier notifier;
    private final boolean checkModified;
    private final int maxDepth;
    private final Map<Path, SingleDirectoryMonitor.DirectoryMonitorHandle> monitors;

    public static DirectoryMonitor start(File folder, boolean checkModified, IDirectoryNotifier notifier) throws IOException {
        return DirectoryMonitor.startRecursive(folder, checkModified, 0, notifier);
    }

    public static DirectoryMonitor startRecursive(File folder, boolean checkModified, int maxDepth, IDirectoryNotifier notifier) throws IOException {
        Path p = FileSystems.getDefault().getPath(folder.getAbsolutePath(), new String[0]);
        return new DirectoryMonitor(p, checkModified, maxDepth, notifier);
    }

    public void checkForChanges() {
        this.monitors.values().forEach(SingleDirectoryMonitor.DirectoryMonitorHandle::checkForChanges);
    }

    public void stop() {
        this.monitors.values().parallelStream().forEach(SingleDirectoryMonitor.DirectoryMonitorHandle::stop);
    }

    private DirectoryMonitor(Path topDir, boolean checkModified, int maxDepth, IDirectoryNotifier notifier) throws IOException {
        this.topDir = topDir;
        this.notifier = notifier;
        this.checkModified = checkModified;
        this.maxDepth = maxDepth;
        this.monitors = this.startup();
    }

    private Map<Path, SingleDirectoryMonitor.DirectoryMonitorHandle> startup() throws IOException {
        try (Stream<Path> fileStream = Files.find(this.topDir, this.maxDepth, (p, a) -> a.isDirectory(), new FileVisitOption[0]);){
            Map map = fileStream.collect(Collectors.toConcurrentMap(p -> p, p -> this.newMonitor((Path)p, false)));
            return map;
        }
    }

    private void fileEvent(IDirectoryNotifier.TYPE type, Path changedFile) {
        if (type == IDirectoryNotifier.TYPE.DELETED) {
            this.monitors.remove(changedFile);
        } else if (Files.isDirectory(changedFile, new LinkOption[0])) {
            this.monitors.computeIfAbsent(changedFile, p -> this.newMonitor((Path)p, type == IDirectoryNotifier.TYPE.CREATED));
        }
        this.notifier.fileEvent(type, changedFile);
    }

    private SingleDirectoryMonitor.DirectoryMonitorHandle newMonitor(Path p, boolean isNew) {
        if (p.getNameCount() > this.topDir.getNameCount() + this.maxDepth) {
            return null;
        }
        try {
            return SingleDirectoryMonitor.create(p, this::fileEvent, this.checkModified, isNew, this.maxDepth != 0);
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }
}

