/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.extension;

import com.silabs.java.utils.ITypedFilter;
import com.silabs.java.utils.ListenerList;
import com.silabs.java.utils.extension.Extension;
import com.silabs.java.utils.extension.IExtensionElementHandler;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.IExtensionManager;
import com.silabs.java.utils.log.Log;
import java.util.HashMap;
import java.util.Map;

public class ExtensionManager
implements IExtensionManager {
    private String extensionPointId;
    private ITypedFilter<IExtensionInformation> filter;
    private ListenerList<Runnable> startupHooks = new ListenerList();
    private Map<String, IExtensionElementHandler> handlers = new HashMap<String, IExtensionElementHandler>();
    private IExtensionElementHandler extensionRegistryListener;
    private volatile boolean isStarted = false;
    private volatile boolean isShutdown = false;

    public ExtensionManager(String extensionPointNamespace, String extensionPointName, ITypedFilter<IExtensionInformation> filter) {
        if (extensionPointNamespace == null || extensionPointName == null) {
            throw new IllegalArgumentException();
        }
        this.extensionPointId = extensionPointNamespace + "." + extensionPointName;
        this.filter = filter;
    }

    @Override
    public void addPostStartupHook(Runnable runnable2) {
        this.startupHooks.add(runnable2);
    }

    @Override
    public synchronized void startup() {
        if (this.isStarted || this.isShutdown) {
            return;
        }
        this.isStarted = true;
        IExtensionInformation[] initialElements = (IExtensionInformation[])Extension.instance().extensions(this.extensionPointId, e -> e).toArray(IExtensionInformation[]::new);
        this.handleConfigurationElements(initialElements, true);
        this.extensionRegistryListener = (ext, added, context) -> this.handleConfigurationElement(added, ext);
        Extension.instance().registerExtensionListener(this.extensionPointId, this.extensionRegistryListener);
        for (Runnable hook : this.startupHooks) {
            hook.run();
        }
    }

    @Override
    public void dispose() {
        Extension.instance().removeExtensionListener(this.extensionPointId, this.extensionRegistryListener);
        this.extensionRegistryListener = null;
        this.isStarted = false;
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
        this.dispose();
    }

    @Override
    public void addHandler(String elementName, IExtensionElementHandler handler) {
        if (this.handlers.put(elementName, handler) != null) {
            Log.warning("overriding handler for " + elementName);
        }
    }

    private String describe(IExtensionInformation el) {
        return "for " + this.extensionPointId + "/" + el.getName() + " from " + el.getNamespaceIdentifier();
    }

    private void handleConfigurationElements(IExtensionInformation[] els, boolean added) {
        for (IExtensionInformation el : els) {
            this.handleConfigurationElement(added, el);
        }
    }

    private void handleConfigurationElement(boolean added, IExtensionInformation el) {
        if (this.filter != null && !this.filter.accept(el)) {
            return;
        }
        this.handle(el, added, null);
    }

    @Override
    public void handle(IExtensionInformation el, boolean added, Object context) {
        if (!el.isValid()) {
            return;
        }
        String name = el.getName();
        IExtensionElementHandler handler = this.handlers.get(name);
        if (handler != null) {
            try {
                handler.handle(el, added, context);
            }
            catch (Throwable t) {
                Log.error("error when handling extension " + this.describe(el), t);
            }
        }
    }
}

