/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.TextUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StringTemplate {
    public static List<String> extractArguments(String command, String startPattern, String endPattern) throws ParseException {
        return StringTemplate.extractArguments(command, startPattern, endPattern, null);
    }

    public static List<String> extractArguments(String command, String startPattern, String endPattern, IPatternDecorator startPatternDecorator) throws ParseException {
        int nextStart;
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while ((nextStart = command.indexOf(startPattern, i)) >= 0) {
            int[] bounds;
            int nextEnd = command.indexOf(endPattern, nextStart + startPattern.length());
            if (nextEnd < 0) {
                throw new ParseException("Missing '" + endPattern + "'", nextStart);
            }
            if (startPatternDecorator != null && (bounds = startPatternDecorator.decoratorBounds(command.substring(nextStart + startPattern.length(), nextEnd).trim())).length == 2) {
                nextStart += bounds[1];
            }
            String key = command.substring(nextStart + startPattern.length(), nextEnd);
            i = nextEnd + endPattern.length();
            if (key.contains("?") && key.contains(":")) {
                String[] argParts;
                int idx = key.indexOf("?");
                String arg = key.substring(0, idx).trim();
                if (arg.contains("=") && (argParts = arg.contains("==") ? arg.split("==") : arg.split("!=")).length > 0) {
                    arg = argParts[0];
                }
                arguments.add(arg);
                continue;
            }
            arguments.add(key);
        }
        return arguments;
    }

    public static String replaceTokensSimple(String pattern, Map<String, ? extends Object> tokenMap, String startPattern, String endPattern) {
        if (pattern == null) {
            return null;
        }
        String returnValue = pattern;
        for (String key : tokenMap.keySet()) {
            String value = TextUtils.print(tokenMap.get(key));
            returnValue = returnValue.replace(startPattern + key + endPattern, value);
        }
        return returnValue;
    }

    public static String replaceTokenExpressions(String pattern, Map<String, ? extends Object> tokenMap, String startPattern, String endPattern) {
        return StringTemplate.replaceTokenExpressions(pattern, tokenMap, startPattern, endPattern, null);
    }

    public static String replaceTokenExpressions(String pattern, Map<String, ? extends Object> tokenMap, String startPattern, String endPattern, IPatternDecorator startPatternDecorator) {
        int keyEnd;
        int keyStart;
        if (pattern == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int currentIndex = 0;
        while ((keyStart = pattern.indexOf(startPattern, currentIndex)) != -1 && (keyEnd = pattern.indexOf(endPattern, keyStart)) != -1) {
            Object value;
            String key;
            int[] bounds;
            output.append(pattern.substring(currentIndex, keyStart));
            IPatternDecorator useDecorator = null;
            String decoratorOption = "";
            if (startPatternDecorator != null && (bounds = startPatternDecorator.decoratorBounds(pattern.substring(keyStart + startPattern.length(), keyEnd).trim())).length == 2) {
                if (bounds[0] > 0) {
                    decoratorOption = pattern.substring(keyStart + startPattern.length(), keyStart + startPattern.length() + bounds[0]);
                }
                keyStart += bounds[1];
                useDecorator = startPatternDecorator;
            }
            if ((key = pattern.substring(keyStart + startPattern.length(), keyEnd).trim()).contains("?") && key.contains(":") && key.indexOf(":") > key.indexOf("?")) {
                int i = key.indexOf("?");
                int j = key.indexOf(":");
                String actualKey = key.substring(0, i).trim();
                String trueValue = key.substring(i + 1, j).trim();
                String falseValue = key.substring(j + 1).trim();
                if (actualKey.contains("=")) {
                    Object val;
                    boolean shouldEqual;
                    String[] akParts;
                    if (actualKey.contains("==")) {
                        akParts = actualKey.split("==");
                        shouldEqual = true;
                    } else {
                        akParts = actualKey.split("!=");
                        shouldEqual = false;
                    }
                    value = akParts.length == 2 ? ((val = tokenMap.get(akParts[0].trim())) instanceof String ? (((String)val).compareTo(akParts[1].trim()) == 0 ? (shouldEqual ? trueValue : falseValue) : (shouldEqual ? falseValue : trueValue)) : falseValue) : falseValue;
                } else if (tokenMap.get(actualKey) == Boolean.TRUE) {
                    value = trueValue;
                    if (tokenMap.containsKey(value)) {
                        value = tokenMap.get(value).toString();
                    }
                } else {
                    value = falseValue;
                    if (tokenMap.containsKey(value)) {
                        value = tokenMap.get(value).toString();
                    }
                }
            } else {
                Object x = tokenMap.get(key);
                value = x == null ? startPattern + key + endPattern : (useDecorator != null ? useDecorator.printArguments(decoratorOption, tokenMap.get(key)) : TextUtils.print(tokenMap.get(key)));
            }
            output.append((String)value);
            currentIndex = keyEnd + endPattern.length();
        }
        output.append(pattern.substring(currentIndex));
        return output.toString();
    }

    public static List<String> tokenize(String cli) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        int state = 0;
        for (int i = 0; i < cli.length(); ++i) {
            char c = cli.charAt(i);
            if (Character.isWhitespace(c)) {
                if (currentToken.length() <= 0) continue;
                switch (state) {
                    case 2: {
                        currentToken.append(c);
                        break;
                    }
                    case 1: {
                        currentToken.append('$');
                    }
                    case 0: {
                        tokens.add(currentToken.toString());
                        currentToken.delete(0, currentToken.length());
                    }
                }
                continue;
            }
            if (c == '$') {
                switch (state) {
                    case 0: {
                        state = 1;
                        break;
                    }
                    case 1: 
                    case 2: {
                        currentToken.append(c);
                        state = 0;
                    }
                }
                continue;
            }
            if (c == '{') {
                switch (state) {
                    case 1: {
                        state = 2;
                        currentToken.append("${");
                        break;
                    }
                    case 0: 
                    case 2: {
                        currentToken.append(c);
                    }
                }
                continue;
            }
            if (c == '}') {
                switch (state) {
                    case 0: {
                        currentToken.append(c);
                        break;
                    }
                    case 1: {
                        currentToken.append('$');
                    }
                    case 2: {
                        currentToken.append(c);
                        state = 0;
                    }
                }
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }

    public static interface IPatternDecorator {
        public int[] decoratorBounds(String var1);

        public String printArguments(String var1, Object var2);
    }
}

