/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtils {
    private static long networkInterfaceRefreshInterval = 5000L;
    private static long nextNetworkInterfaceFetch = 0L;
    private static NetworkInterface[] lastNetworkInterfaces;

    private static NetworkInterface[] getRecentNetworkInterfaces() {
        long now = System.currentTimeMillis();
        if (now >= nextNetworkInterfaceFetch) {
            block4: {
                try {
                    ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        list.add(en.nextElement());
                    }
                    lastNetworkInterfaces = list.toArray(new NetworkInterface[list.size()]);
                }
                catch (SocketException e) {
                    if (lastNetworkInterfaces != null) break block4;
                    lastNetworkInterfaces = new NetworkInterface[0];
                }
            }
            nextNetworkInterfaceFetch = now + networkInterfaceRefreshInterval;
        }
        return lastNetworkInterfaces;
    }

    public static void setNetworkInterfaceRefreshInterval(long interval) {
        networkInterfaceRefreshInterval = interval;
    }

    public static long networkInterfaceRefreshInterval() {
        return networkInterfaceRefreshInterval;
    }

    public static List<byte[]> getMacAddresses() throws UnknownHostException, SocketException {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (NetworkInterface ni : NetworkUtils.getRecentNetworkInterfaces()) {
            byte[] mac = ni.getHardwareAddress();
            if (mac == null || list.contains(mac)) continue;
            list.add(mac);
        }
        return list;
    }

    public static boolean isMyAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        for (NetworkInterface ni : NetworkUtils.getRecentNetworkInterfaces()) {
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress ia = addrs.nextElement();
                if (!ipAddress.equals(ia.getHostAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<InetAddress> getIpAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            for (NetworkInterface ni : NetworkUtils.getRecentNetworkInterfaces()) {
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress ia = addrs.nextElement();
                    if (ia.isLoopbackAddress() || addresses.contains(ia)) continue;
                    addresses.add(ia);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return addresses;
    }

    public static boolean isInternalNetwork() {
        try {
            InetAddress ia = InetAddress.getByName("silabs.com");
            String ip = ia.getHostAddress();
            return ip != null && ip.startsWith("10.");
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }
}

