/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.vscodecmake;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.core.utils.IGeneratorPathManager;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.NonTemplateFileGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.INonTemplateContext;
import com.silabs.ss.framework.project.internal.core.type.generic.model.NonTemplateFileContext;
import com.silabs.ss.platform.api.rcp.core.DevUtils;
import org.eclipse.core.runtime.IPath;

public class SvdFileGenerator
extends NonTemplateFileGenerator {
    private static final String SVD_PATH = "offline/svd";
    private static final String SVD_EXTENSION = ".svd";

    @Override
    public void generate(INonTemplateContext context) {
        try {
            NonTemplateFileContext projectContext = (NonTemplateFileContext)context;
            IGeneratorPathManager svdGenerator = projectContext.getSvdPathManager();
            if (svdGenerator == null) {
                return;
            }
            String partId = projectContext.getPartId();
            String partNumber = projectContext.getPartNumber();
            if (TextUtils.isBlank((String)partId) || TextUtils.isBlank((String)partNumber)) {
                return;
            }
            IPath svdFolder = this.getRootSupportFolder().append(SVD_PATH);
            IPath filePath = svdFolder.append(partNumber + SVD_EXTENSION);
            if (filePath.toFile().isFile()) {
                return;
            }
            if (!svdFolder.toFile().isDirectory()) {
                svdFolder.toFile().mkdirs();
            }
            svdGenerator.writeSvdTo(partId, filePath.toFile().toPath());
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
    }

    private IPath getRootSupportFolder() {
        if (RuntimeUtils.isJUnitRunning()) {
            return DevUtils.getWorkspaceLocation();
        }
        return DevUtils.getInstallPath();
    }
}

