/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.slsproj;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.IParentable;
import com.silabs.java.utils.MapUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.java.utils.variables.engine.StockVariables;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.MProjectCanonicalizer;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.BaseExternalProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.ExportSLSProjectModelEngine;
import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.AddIncludePathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryFileSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryPathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddMacroDefinitionSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectResourceFilterOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddSourceFolderToConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseLanguageAwareProjectSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IConfigurationScopeEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFileProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ILinkIntoProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEntryEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IncludeResourceIntoConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ResetModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationOutputBaseNameOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPrebuildStepOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.model.IResourceFilterInfo;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.utils.ProjectModelObjFactory;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngineFactory;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectPropertiesHandler;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptorEntity;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class SlsprojProjectOperationHandler
extends BaseExternalProjectEngineOperationHandler
implements IProjectEngineOperationHandler {
    public static final String CANONICALIZE_PATHS = "canonicalizePaths";
    private MProject project;
    private IProjectModel model;
    private Map<String, MConfiguration> configMap;
    private Map<IPath, List<Consumer<MEntry>>> cachedRunnables;
    private IProjectDescriptor projDesc;
    private IProjectEngineSession session;
    private Map<String, List<IModuleReference>> modRefs;
    private Map<String, MProject> pdms;
    private Collection<String> removedPaths;
    private Set<ICopiedFileReference> copiedFiles;
    private boolean shouldCleanExclusions = true;

    public SlsprojProjectOperationHandler(IProjectDescriptor projDesc) {
        this(null, projDesc);
    }

    public SlsprojProjectOperationHandler(IExternalProjectEntity projEnt) {
        this(projEnt, (IProjectDescriptor)projEnt.getDescriptor());
    }

    private SlsprojProjectOperationHandler(IExternalProjectEntity projEnt, IProjectDescriptor projDesc) {
        super(projEnt);
        this.projDesc = projDesc;
        this.configMap = new HashMap<String, MConfiguration>();
        this.cachedRunnables = new HashMap<IPath, List<Consumer<MEntry>>>();
        this.modRefs = new HashMap<String, List<IModuleReference>>();
        this.pdms = new HashMap<String, MProject>();
        this.removedPaths = new HashSet<String>();
        this.copiedFiles = new HashSet<ICopiedFileReference>((Collection)(projEnt == null ? projDesc : projEnt).getProperty(ProjectProperties.COPIED_FILES));
    }

    public MProject getProject() {
        return this.project;
    }

    public IProjectEngineSession getSession() {
        return this.session;
    }

    @Override
    public IProjectDescriptor getProjectDescriptor() {
        return this.projDesc;
    }

    @Override
    protected Collection<ICopiedFileReference> copiedFiles() {
        return this.copiedFiles;
    }

    @Override
    public void load() throws CoreException {
        this.project = ProjectModelFactory.eINSTANCE.createMProject();
        this.project.setName(this.getProjectDescriptor().getName());
        this.project.setContentRoot(".");
        IBuildConfigurationDescriptor[] bconfs = this.getProjectDescriptor().getBuildConfigurationDescriptors();
        if (bconfs.length == 0 && this.getProjectEntity() != null) {
            bconfs = (IBuildConfigurationDescriptor[])Stream.of(this.getProjectEntity().getBuildConfigurations()).map(IDescriptorEntity::getDescriptor).toArray(IBuildConfigurationDescriptor[]::new);
        }
        IBuildConfigurationDescriptor[] iBuildConfigurationDescriptorArray = bconfs;
        int n = bconfs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigurationDescriptor bconf = iBuildConfigurationDescriptorArray[n2];
            MConfiguration config = ProjectModelUtils.findOrAddNewConfigurationFor(this.project, bconf);
            this.configMap.put(bconf.getId(), config);
            ++n2;
        }
        this.reloadModel();
    }

    private void reloadModel() {
        IVariableLookup store = Optional.ofNullable(this.session).map(IProjectEngineSession::getProjectModel).map(IProjectModel::getVariableLookup).orElse(null);
        if (store == null) {
            store = new MapVariableLookup();
            StockVariables.INSTANCE.setVariables((IVariableStore)store, this.getProjectEntity() == null ? this.projDesc : this.getProjectEntity());
        }
        if (this.model == null) {
            this.model = ProjectModelEngineFactory.INSTANCE.createProjectModel(this.project, store);
            this.model.setContentRootURI(this.getOutputDirectory().toURI());
        } else {
            this.model = ProjectModelEngineFactory.INSTANCE.createExistingProjectModel(this.model.getModel(), store, this.model.getContentRootURI(), this.model.getProjectResourceTree());
        }
    }

    @Override
    public void commit() throws CoreException {
        File outFile;
        if (this.shouldCleanExclusions) {
            this.removedPaths.stream().filter(p -> ProjectModelUtils.findEntry(this.model, (MFolderEntry)this.model.getModel(), (IPath)new Path(p)) == null).forEachOrdered(p -> {
                this.model.getModel().getExcludedPaths().remove(p);
                this.model.getModel().getConfigurations().forEach(c -> {
                    boolean bl = c.getExcludedPaths().remove(p);
                });
            });
        }
        Stream<IParentable<IProjectDescriptor>> descsToSet = this.getProjectEntity() == null ? Stream.concat(Stream.of(this.getProjectDescriptor()), Stream.of(this.getProjectDescriptor().getBuildConfigurationDescriptors())) : Stream.concat(Stream.of(this.getProjectEntity()), Stream.of(this.getProjectEntity().getBuildConfigurations()));
        descsToSet.map(IWriteableDescriptor.class::cast).forEach(this::updateRequiredProperties);
        this.project.getProjectDefinedModules().addAll(this.pdms.values());
        this.setProps((MDescriptor)this.project, ProjectProperties.COPIED_FILES, this.copiedFiles);
        if (this.getProjectEntity().getProperty(CANONICALIZE_PATHS) != Boolean.FALSE) {
            MProjectCanonicalizer canonicalizer = new MProjectCanonicalizer(this.model, this.projDesc, true, true);
            canonicalizer.doSwitch((EObject)this.project);
            this.project.getProjectDefinedModules().forEach(arg_0 -> ((MProjectCanonicalizer)canonicalizer).doSwitch(arg_0));
        }
        if (RuntimeUtils.isJUnitRunning() && (outFile = this.getProjectEntity().getInstallationFile()).exists()) {
            String contents = "";
            try {
                contents = new String(FileUtils.readFileContents((File)outFile, null));
            }
            catch (Exception exception) {}
            if (contents.contains("FAIL TEST GENERATION")) {
                throw new IllegalStateException("Test generation failure requested.");
            }
        }
        if (this.getProjectEntity() instanceof IExternalProjectEntity) {
            IExternalProjectEntity projEnt = this.getProjectEntity();
            projEnt.setFileContents(projEnt.getInstallationFile(), new ExportSLSProjectModelEngine().convertProjectToString(this.project));
        }
    }

    private void updateRequiredProperties(IWriteableDescriptor desc) {
        MConfiguration mdesc = desc instanceof IBuildConfigurationDescriptor || desc instanceof IBuildConfiguration ? this.project.findConfiguration((IDescriptor)desc) : this.project;
        List<IModuleReference> modRefs = this.getModRefs((IDescriptor)desc);
        this.setProps((MDescriptor)mdesc, ProjectCommonProperties.REFERENCED_MODULES, modRefs);
        ExternalProjectPropertiesHandler.saveProperties((IDescriptor)desc, (arg_0, arg_1) -> SlsprojProjectOperationHandler.lambda$10((MDescriptor)mdesc, arg_0, arg_1));
    }

    private <T> void setProps(MDescriptor mdesc, PropertyReference<T> prop, T vals) {
        if (mdesc == null) {
            return;
        }
        String strinizeVals = prop.type().stringize(vals);
        mdesc.getProperties().put((Object)prop.id(), (Object)strinizeVals);
    }

    private List<IModuleReference> getModRefs(IDescriptor desc) {
        if (desc instanceof IProjectDescriptor || desc instanceof IProjectEntity) {
            return this.modRefs.get(null);
        }
        return this.modRefs.get(desc.getId());
    }

    @Override
    protected void handleAddCopiedFileReference(ICopiedFileReference reference) {
        this.copiedFiles.remove(reference);
        this.copiedFiles.add(reference);
    }

    @Override
    public void handleRemoveProjectFileOperation(RemoveProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        super.handleRemoveProjectFileOperation(operation, monitor);
        this.removedPaths.add(operation.getProjectPath().toPortableString());
    }

    @Override
    public void handleRemoveProjectFolderOperation(RemoveProjectFolderOperation operation, IProgressMonitor monitor) throws CoreException {
        super.handleRemoveProjectFolderOperation(operation, monitor);
        this.removedPaths.add(operation.getProjectPath().toPortableString());
    }

    @Override
    public void handleAddProjectResourceFilterOperation(AddProjectResourceFilterOperation operation, IProgressMonitor monitor) throws CoreException {
        ArrayList<IResourceFilterInfo> list = (ArrayList<IResourceFilterInfo>)this.project.getFilterInfoMap().get(operation.getProjectPath());
        if (list == null) {
            list = new ArrayList<IResourceFilterInfo>();
            this.project.getFilterInfoMap().put(operation.getProjectPath(), list);
        }
        list.add(operation.getResourceFilterInfo());
    }

    @Override
    public void handleAddSourceFolderToConfigurationOperation(AddSourceFolderToConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        site.getSourceFolders().add((Object)operation.getProjectPath().toString());
    }

    @Override
    public void handleExcludeResourceFromConfigurationOperation(ExcludeResourceFromConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        site.getExcludedPaths().add((Object)operation.getProjectPath().toString());
    }

    @Override
    public void handleIncludeResourceIntoConfigurationOperation(IncludeResourceIntoConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        site.getExcludedPaths().remove((Object)operation.getProjectPath().toString());
    }

    @Override
    public void handleSetConfigurationOutputBaseNameOperation(SetConfigurationOutputBaseNameOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        site.setOutputFileBase(operation.getOutputBaseName());
    }

    @Override
    public void handleSetConfigurationPrebuildStepOperation(SetConfigurationPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        site.setPrebuildStep(operation.getPrebuildStep());
    }

    @Override
    public void handleSetConfigurationPostbuildStepOperation(SetConfigurationPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        site.setPostbuildStep(operation.getPostbuildStep());
    }

    @Override
    public void handleAddIncludePathSettingOperation(AddIncludePathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        ProjectModelObjFactory.CreateMIncludePath factory = (ProjectModelObjFactory.CreateMIncludePath)ProjectModelObjFactory.forMIncludePath(operation.getUri().toString()).set(inc -> inc.setUser(operation.isUser()));
        this.setupSettings(operation, (MBuildSetting)factory.get());
        this.addForFactory(operation, site, factory);
    }

    @Override
    public void handleAddMacroDefinitionSettingOperation(AddMacroDefinitionSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        ProjectModelObjFactory.CreateMMacroDefinition factory = ProjectModelObjFactory.forMMacroDefinition(operation.getName(), operation.getValue());
        this.setupSettings(operation, (MBuildSetting)factory.get());
        this.addForFactory(operation, site, factory);
    }

    @Override
    public void handleAddToolOptionOperation(AddToolOptionOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        ProjectModelObjFactory.CreateMToolOption factory = ProjectModelObjFactory.forMToolOption(operation.getToolId(), operation.getOptionId()).setValue(operation.getValue());
        this.setupSettings(operation, (MBuildSetting)factory.get());
        for (AddToolOptionOperation.AddToolListOptionOperation opVal : operation.getListOperatons()) {
            factory.newListOption(opVal.getValue()).set(op -> op.setBuiltin(opVal.isBuiltin())).apply();
        }
        this.addForFactory(operation, site, factory);
    }

    private boolean isEmptyPath(IProjectEntryEngineOperation operation) {
        return operation.getProjectPath() == null || Path.EMPTY.equals((Object)operation.getProjectPath());
    }

    @Override
    public void handleAddLibraryPathSettingOperation(AddLibraryPathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        MLibraryPath libPath = ProjectModelFactory.eINSTANCE.createMLibraryPath();
        libPath.setUri(operation.getLibraryURI().toString());
        this.setupSettings(operation, (MBuildSetting)libPath);
        site.getLibraryPaths().add((Object)libPath);
    }

    @Override
    public void handleAddLibraryFileSettingOperation(AddLibraryFileSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        MConfigSettings site = this.getConfig(operation);
        MLibraryFile libFile = ProjectModelFactory.eINSTANCE.createMLibraryFile();
        Optional<AddLibraryFileSettingOperation> op = Optional.of(operation);
        op.map(AddLibraryFileSettingOperation::getLibraryURI).map(Object::toString).ifPresent(arg_0 -> ((MLibraryFile)libFile).setUri(arg_0));
        op.map(AddLibraryFileSettingOperation::getLibraryName).ifPresent(arg_0 -> ((MLibraryFile)libFile).setName(arg_0));
        this.setupSettings(operation, (MBuildSetting)libFile);
        site.getLibraryFiles().add((Object)libFile);
    }

    private void setupSettings(BaseLanguageAwareProjectSettingOperation operation, MBuildSetting bSetting) {
        bSetting.setLanguageCompatibility(operation.getLanguageCompatibility());
        bSetting.setBuiltin(operation.isBuiltin());
    }

    private void addForFactory(BaseLanguageAwareProjectSettingOperation operation, MConfigSettings config, ProjectModelObjFactory.BaseCreateObject<?, ?> factory) {
        if (!this.isEmptyPath(operation)) {
            this.handleEntryOperation((EMap<MEntry, MSettingsSite>)config.getEntrySettings(), operation.getProjectPath(), factory);
        } else {
            factory.apply((MSettingsSite)config);
        }
    }

    private void handleEntryOperation(EMap<MEntry, MSettingsSite> entrySettings, IPath projectPath, ProjectModelObjFactory.BaseCreateObject<?, ?> factory) {
        MEntry entry = ProjectModelUtils.findEntry(this.model, (MFolderEntry)this.project, projectPath);
        if (entry == null) {
            List<Consumer<MEntry>> entRuns = this.cachedRunnables.get(projectPath);
            if (entRuns == null) {
                entRuns = new ArrayList<Consumer<MEntry>>();
                this.cachedRunnables.put(projectPath, entRuns);
            }
            entRuns.add(e -> this.addToSite(entrySettings, (MEntry)e, factory));
        } else {
            this.addToSite(entrySettings, entry, factory);
        }
    }

    private void handleNewEntry(MEntry entry, IPath projectPath) {
        List<Consumer<MEntry>> entRuns = this.cachedRunnables.get(projectPath);
        if (entRuns == null) {
            return;
        }
        entRuns.forEach(f -> f.accept(entry));
    }

    private void addToSite(EMap<MEntry, MSettingsSite> entrySettings, MEntry entry, ProjectModelObjFactory.BaseCreateObject<?, ?> factory) {
        MSettingsSite entrySite = (MSettingsSite)entrySettings.get((Object)entry);
        if (entrySite == null) {
            entrySite = ProjectModelFactory.eINSTANCE.createMConfiguration();
            entrySettings.put((Object)entry, (Object)entrySite);
        }
        factory.apply(entrySite);
    }

    @Override
    public void handleResetModuleReferencesOperation(ResetModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
        this.session = operation.getSession();
        this.reloadModel();
        ((List)MapUtils.findOrCreate(this.modRefs, (Object)operation.getBuildConfiguration(), ArrayList::new)).clear();
        this.getConfig(operation).getModules().clear();
    }

    @Override
    public void handleAddModuleReferenceOperation(AddModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        if (!operation.getModuleReference().isRemoved()) {
            MConfigSettings site = this.getConfig(operation);
            site.getModules().add((Object)operation.getModuleReference().getModule());
        }
        ((List)MapUtils.findOrCreate(this.modRefs, (Object)operation.getBuildConfiguration(), ArrayList::new)).add(operation.getModuleReference());
    }

    private MConfigSettings getConfig(IConfigurationScopeEngineOperation operation) {
        if (TextUtils.isEmpty((String)operation.getBuildConfiguration())) {
            return this.project;
        }
        return (MConfigSettings)this.configMap.get(operation.getBuildConfiguration());
    }

    @Override
    public void handleAddProjectDefinedModuleOperation(AddProjectDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        this.pdms.put(operation.getModuleDefinition().getName(), operation.getModuleDefinition());
    }

    @Override
    protected void registerProjectFile(IAddToProjectEngineOperation op, IPath prjPath, File fileLoc) {
        Object content = op instanceof IHandleFileProjectEngineOperation ? ProjectModelUtils.findOrCreateFileContent(this.model, this.project, prjPath, fileLoc.toURI().toString()) : (op instanceof CreateProjectFolderOperation ? ProjectModelUtils.findOrCreateFolder(this.model, (MFolderEntry)this.project, prjPath) : ProjectModelUtils.findOrCreateFolderContent(this.model, this.project, prjPath, fileLoc.getPath()));
        if (content instanceof MContent) {
            ((MContent)content).setLinked(Boolean.valueOf(op instanceof ILinkIntoProjectEngineOperation));
        }
        this.handleNewEntry((MEntry)content, op.getProjectPath());
    }

    private static /* synthetic */ void lambda$10(MDescriptor mDescriptor, String prop, String val) {
        Object object = mDescriptor.getProperties().put((Object)prop, (Object)val);
    }
}

