/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.ses;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.DocumentRoot;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfiguration;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfigurationContainer;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESFile;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESFolder;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESModelFactory;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESProject;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESSolution;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.util.SESModelResourceFactoryImpl;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public final class SESModelUtils {
    public static final String EXTENSION_SES = "emProject";
    public static final String END_OF_LINE = "\n";
    public static final String VAR_PROJ_DIR = "$(ProjectDir)";
    private static final int SES_CONFIG_WRAP_LENGTH = 78;
    private static boolean DEBUG = false;

    private SESModelUtils() {
    }

    public static SESSolution loadSESSolution(File sesFile) {
        SESModelResourceFactoryImpl factory = new SESModelResourceFactoryImpl();
        Resource resource = factory.createResource(URI.createFileURI((String)sesFile.getAbsolutePath()));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            Activator.reporter.logError("failed to load " + String.valueOf(sesFile), (Throwable)e);
            return null;
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        if (root == null) {
            Activator.reporter.logInfo("Document " + String.valueOf(sesFile) + " has no root.");
            return null;
        }
        SESSolution solution = root.getSolution();
        return solution;
    }

    public static void writeSESFile(SESSolution model, File sesFile) {
        String sesStr = SESModelUtils.serializeSESSolution(model);
        if (TextUtils.isEmpty((String)sesStr)) {
            return;
        }
        try {
            sesFile.getParentFile().mkdirs();
            FileUtils.writeFileContents((File)sesFile, (String)sesStr);
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to write SES emProject file to disk!", (Throwable)e);
        }
    }

    public static String serializeSESSolution(SESSolution model) {
        SESModelResourceFactoryImpl factory = new SESModelResourceFactoryImpl();
        Resource rsrc = factory.createResource(null);
        rsrc.getContents().add((Object)model);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            rsrc.save((OutputStream)bos, null);
        }
        catch (IOException e) {
            Activator.reporter.logError("failed to convert SES model to string", (Throwable)e);
            return "";
        }
        String rawSolution = new String(bos.toByteArray());
        return SESModelUtils.modifySESSolutionString(rawSolution);
    }

    private static String modifySESSolutionString(String solution) {
        Object modSolution = solution.substring(solution.indexOf(62) + 1);
        String docType = "<!DOCTYPE CrossStudio_Project_File>";
        modSolution = docType + (String)modSolution;
        List modSolutionLines = ((String)modSolution).lines().collect(Collectors.toList());
        ArrayList<String> newSolutionLines = new ArrayList<String>();
        for (String solutionLine : modSolutionLines) {
            if (solutionLine.matches("(?i)\\s*<configuration.*")) {
                String newConfigString = SESModelUtils.modifyConfigurationString(solutionLine);
                if (DEBUG) {
                    System.out.println("Formatted Configuration:" + newConfigString);
                }
                newSolutionLines.add(newConfigString);
                continue;
            }
            newSolutionLines.add(solutionLine);
        }
        Object newSolution = String.join((CharSequence)END_OF_LINE, newSolutionLines);
        newSolution = ((String)newSolution).replaceAll("/>", " />");
        newSolution = (String)newSolution + END_OF_LINE;
        return newSolution;
    }

    private static String modifyConfigurationString(String configString) {
        if (configString.length() < 78) {
            if (DEBUG) {
                System.out.println("Config is short, so don't modify.");
            }
            return configString;
        }
        int startingIndex = SESModelUtils.indexOfFirstNonWhiteSpace(configString);
        String initialLeadingSpaces = configString.substring(0, SESModelUtils.indexOfFirstNonWhiteSpace(configString));
        String optionsLeadingSpaces = SESModelUtils.leadingSpaces(startingIndex + 2);
        String restOfLine = configString.trim();
        restOfLine = restOfLine.substring(restOfLine.indexOf(" ") + 1);
        if (DEBUG) {
            System.out.println("Config Options Only:" + restOfLine);
        }
        String firstConfigLine = initialLeadingSpaces + "<configuration";
        List configOptionsList = Stream.of(restOfLine.split("\" ")).collect(Collectors.toList());
        if (DEBUG) {
            System.out.println("Options List:" + String.valueOf(configOptionsList));
        }
        TreeMap<String, String> configOptions = new TreeMap<String, String>();
        for (String option : configOptionsList) {
            String optionName = option.substring(0, option.indexOf(61) + 1);
            String optionValue = option.substring(option.indexOf(61) + 1).replace("\"/>", "");
            configOptions.put(optionName, optionValue);
        }
        if (DEBUG) {
            System.out.println("Config Options:" + String.valueOf(configOptions));
        }
        StringBuilder modConfigLine = new StringBuilder();
        String result = "";
        modConfigLine.append(firstConfigLine);
        modConfigLine.append(END_OF_LINE);
        boolean isFirst = true;
        for (Map.Entry optionEntry : configOptions.entrySet()) {
            if (!isFirst) {
                modConfigLine.append(END_OF_LINE);
            }
            modConfigLine.append(optionsLeadingSpaces);
            modConfigLine.append((String)optionEntry.getKey());
            modConfigLine.append((String)optionEntry.getValue());
            modConfigLine.append("\"");
            isFirst = false;
        }
        result = modConfigLine.append("/>").toString();
        return result;
    }

    private static int indexOfFirstNonWhiteSpace(String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String leadingSpaces(int numLeadingSpaces) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < numLeadingSpaces) {
            builder.append(" ");
            ++i;
        }
        return builder.toString();
    }

    public static SESSolution createSolution(String solutionName, String target, String version) {
        SESSolution sesSolution = SESModelFactory.eINSTANCE.createSESSolution();
        sesSolution.setName(solutionName);
        sesSolution.setVersion(version);
        sesSolution.setTarget(target);
        return sesSolution;
    }

    public static SESConfiguration createConfigurationWithOptions(String configName, Map<String, String> configOptions) {
        SESConfiguration sesConfiguration = SESModelFactory.eINSTANCE.createSESConfiguration();
        sesConfiguration.setName(configName);
        for (Map.Entry<String, String> entry : configOptions.entrySet()) {
            EStructuralFeature optionFeature = sesConfiguration.eClass().getEStructuralFeature(entry.getKey());
            sesConfiguration.eSet(optionFeature, entry.getValue());
        }
        return sesConfiguration;
    }

    private static SESConfiguration doFindOrCreateConfiguration(String configName, SESConfigurationContainer container, boolean create) {
        EList<SESConfiguration> configsList = container.getConfigurations();
        for (SESConfiguration currentConfig : configsList) {
            if (!currentConfig.getName().equalsIgnoreCase(configName)) continue;
            return currentConfig;
        }
        SESConfiguration newConfiguration = null;
        if (create) {
            newConfiguration = SESModelFactory.eINSTANCE.createSESConfiguration();
            newConfiguration.setName(configName);
            container.getConfigurations().add((Object)newConfiguration);
        }
        return newConfiguration;
    }

    public static SESConfiguration findConfiguration(String configName, SESConfigurationContainer container) {
        return SESModelUtils.doFindOrCreateConfiguration(configName, container, false);
    }

    public static SESConfiguration findOrCreateConfiguration(String configName, SESConfigurationContainer container) {
        return SESModelUtils.doFindOrCreateConfiguration(configName, container, true);
    }

    public static SESProject findProject(SESSolution model, String projectName) {
        return SESModelUtils.doFindOrCreateProject(model, projectName, false);
    }

    public static SESProject findOrCreateProject(SESSolution model, String projectName) {
        return SESModelUtils.doFindOrCreateProject(model, projectName, true);
    }

    public static SESFolder findFolder(SESSolution solution, IPath dirPath) {
        SESProject folder = null;
        String projectName = dirPath.segment(0);
        folder = SESModelUtils.doFindOrCreateProject(solution, projectName, false);
        if (folder == null) {
            return null;
        }
        if (dirPath.segmentCount() > 1) {
            IPath modDirPath = dirPath.removeFirstSegments(1);
            return SESModelUtils.doFindOrCreateFolder(folder, modDirPath, false);
        }
        return folder;
    }

    public static SESFile findFile(SESSolution solution, IPath dirPath, String file_name) {
        SESFile file = null;
        String projectName = dirPath.segment(0);
        SESProject folder = SESModelUtils.doFindOrCreateProject(solution, projectName, false);
        if (folder == null) {
            return null;
        }
        if (dirPath.segmentCount() > 1) {
            IPath modDirPath = dirPath.removeFirstSegments(1);
            file = SESModelUtils.doFindOrCreateFile(folder, modDirPath, file_name, false);
        }
        return file;
    }

    public static SESFolder findFolder(SESFolder parent, IPath dirPath) {
        return SESModelUtils.doFindOrCreateFolder(parent, dirPath, false);
    }

    public static SESFolder findOrCreateFolder(SESFolder parent, IPath dirPath) {
        return SESModelUtils.doFindOrCreateFolder(parent, dirPath, true);
    }

    public static SESFile findFile(SESFolder parent, IPath dirPath, String file_name) {
        return SESModelUtils.doFindOrCreateFile(parent, dirPath, file_name, false);
    }

    public static SESFile findOrCreateFile(SESFolder parent, IPath dirPath, String file_name) {
        return SESModelUtils.doFindOrCreateFile(parent, dirPath, file_name, true);
    }

    private static SESProject doFindOrCreateProject(SESSolution model, String projectName, boolean create) {
        if (!model.getProjects().isEmpty()) {
            EList<SESProject> sesProjects = model.getProjects();
            for (SESProject currentProject : sesProjects) {
                if (!currentProject.getName().equalsIgnoreCase(projectName)) continue;
                return currentProject;
            }
        }
        SESProject newProject = null;
        if (create) {
            newProject = SESModelFactory.eINSTANCE.createSESProject();
            newProject.setName(projectName);
            model.getProjects().add((Object)newProject);
        }
        return newProject;
    }

    private static SESFolder doFindOrCreateFolder(SESFolder parent, IPath dirPath, boolean create) {
        SESFolder folder = parent;
        int i = 0;
        while (i < dirPath.segmentCount()) {
            String dirName = dirPath.segment(i);
            folder = SESModelUtils.findFolder(parent, dirName);
            if (folder == null) {
                if (create) {
                    SESFolder sesFolder;
                    folder = sesFolder = SESModelFactory.eINSTANCE.createSESFolder();
                    sesFolder.setName(dirName);
                    parent.getFolders().add((Object)sesFolder);
                } else {
                    return null;
                }
            }
            parent = folder;
            ++i;
        }
        return folder;
    }

    private static SESFile doFindOrCreateFile(SESFolder parent, IPath dirPath, String file_name, boolean create) {
        IPath dirPathToDirectParent = dirPath.removeLastSegments(1);
        SESFolder directParentFolder = SESModelUtils.doFindOrCreateFolder(parent, dirPathToDirectParent, create);
        if (directParentFolder == null) {
            return null;
        }
        SESFile file = SESModelUtils.findFile(directParentFolder, dirPath.lastSegment(), file_name);
        if (file == null) {
            if (create) {
                SESFile sesFile;
                file = sesFile = SESModelFactory.eINSTANCE.createSESFile();
                sesFile.setFile_name(file_name);
                directParentFolder.getFiles().add((Object)sesFile);
            } else {
                return null;
            }
        }
        return file;
    }

    private static SESFolder findFolder(SESFolder directParentFolder, String folderName) {
        if (directParentFolder == null) {
            return null;
        }
        EList<SESFolder> childFolders = directParentFolder.getFolders();
        for (SESFolder currentFolder : childFolders) {
            if (!currentFolder.getName().equalsIgnoreCase(folderName)) continue;
            return currentFolder;
        }
        return null;
    }

    private static SESFile findFile(SESFolder directParentFolder, String projectPathName, String file_name) {
        if (directParentFolder == null) {
            return null;
        }
        ArrayList<SESFile> matchedFiles = new ArrayList<SESFile>();
        for (SESFile currentFile : directParentFolder.getFiles()) {
            if (TextUtils.hasContent((String)currentFile.getName()) && !Objects.equals(projectPathName, currentFile.getName()) || !currentFile.getFile_name().endsWith(projectPathName)) continue;
            if (file_name != null && currentFile.getFile_name().equalsIgnoreCase(file_name)) {
                return currentFile;
            }
            matchedFiles.add(currentFile);
        }
        return matchedFiles.size() > 0 ? (SESFile)matchedFiles.get(0) : null;
    }

    public static SESConfigurationContainer findContainer(SESSolution model, SESFolder parent, String entryName) {
        IPath filePath;
        for (SESFolder folder : parent.getFolders()) {
            if (!entryName.equalsIgnoreCase(folder.getName())) continue;
            return folder;
        }
        for (SESFile file : parent.getFiles()) {
            filePath = IPathUtils.createPath((String)file.getFile_name());
            if (!entryName.equalsIgnoreCase(filePath.lastSegment())) continue;
            return file;
        }
        if (model != null) {
            for (SESFolder folder : parent.getFolders()) {
                String name = folder.getName();
                if (!name.equalsIgnoreCase(entryName)) continue;
                return folder;
            }
            for (SESFile file : parent.getFiles()) {
                filePath = IPathUtils.createPath((String)file.getFile_name());
                String name = file.getFile_name();
                if (!name.equalsIgnoreCase(filePath.lastSegment())) continue;
                return file;
            }
        }
        return null;
    }

    public static SESConfigurationContainer findContainer(SESSolution model, SESFolder parent, IPath path) {
        if (Path.EMPTY.equals((Object)path) || path == null) {
            return parent;
        }
        int seg = 0;
        while (seg < path.segmentCount()) {
            SESConfigurationContainer content = SESModelUtils.findContainer(model, parent, path.segment(seg));
            if (content == null) {
                return null;
            }
            if (seg == path.segmentCount() - 1) {
                return content;
            }
            if (!(content instanceof MFolderEntry)) {
                return null;
            }
            parent = (SESFolder)content;
            ++seg;
        }
        return null;
    }

    public static Multimap<String, String> parseSESMacros(String configMacro) {
        String[] macros = configMacro.split(";");
        LinkedHashMultimap macroMap = LinkedHashMultimap.create();
        String[] stringArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            String macro = stringArray[n2];
            String[] nameValPair = macro.split("=");
            if (nameValPair.length == 1) {
                macroMap.put((Object)nameValPair[0], null);
            } else if (nameValPair.length == 2) {
                macroMap.put((Object)nameValPair[0], (Object)nameValPair[1]);
            } else {
                Activator.reporter.logError("Unknown Macro value " + macro);
            }
            ++n2;
        }
        return macroMap;
    }

    public static Map<String, String> parseSESMacrosForConfigOption(String configMacro) {
        if (TextUtils.isEmpty((String)configMacro)) {
            return Collections.emptyMap();
        }
        String[] macros = configMacro.split(";");
        LinkedHashMap<String, String> macroMap = new LinkedHashMap<String, String>();
        String[] stringArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            String macro = stringArray[n2];
            String[] nameValPair = macro.split("=");
            if (nameValPair.length == 1) {
                macroMap.put(nameValPair[0], null);
            } else if (nameValPair.length == 2) {
                macroMap.put(nameValPair[0], nameValPair[1]);
            } else {
                Activator.reporter.logError("Unknown Macro value " + macro);
            }
            ++n2;
        }
        return macroMap;
    }

    public static String stringifySESMacros(Map<String, String> macros) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> macro : macros.entrySet()) {
            String key = macro.getKey();
            String val = macro.getValue();
            builder.append(key);
            if (TextUtils.hasContent((String)val)) {
                builder.append("=");
                builder.append(val);
            }
            builder.append(";");
        }
        String macrosStr = builder.toString();
        macrosStr = macrosStr.substring(0, macrosStr.length() - 1);
        return macrosStr;
    }

    public static Collection<String> parseSESList(String list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(list.split(";"));
    }

    public static String stringifySESList(Collection<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)";", list);
    }
}

