/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile.options;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalOptionsUtils;
import com.silabs.ss.framework.project.internal.core.type.makefile.StringTemplatePropertyConverter;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyConverter;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.rcp.core.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class MakefileExternalOptions
extends ExternalOptionsUtils {
    public static final PropertyReference<String> MAKEFILE_CONVERTER = CoreTypes.STRING.property("makefileConverter");
    private static final Map<String, IPropertyConverter> converterMap = new ConcurrentHashMap<String, IPropertyConverter>();

    public static String convertToValue(IProperty prop, Object baseValue) {
        String converterClass = (String)prop.getProperty(MAKEFILE_CONVERTER);
        if (TextUtils.isEmpty((String)converterClass)) {
            return baseValue == null ? "" : String.valueOf(baseValue);
        }
        IPropertyConverter converter = converterMap.computeIfAbsent(converterClass, MakefileExternalOptions::loadClass);
        if (converter == null) {
            return "";
        }
        return converter.convertToString(prop, baseValue, null);
    }

    private static IPropertyConverter loadClass(String converterClass) {
        BundleContext context;
        block3: {
            context = Activator.getContext();
            if (context != null) break block3;
            return null;
        }
        try {
            Class clazz = ClassUtils.loadClass((Bundle)context.getBundle(), (String)converterClass, IPropertyConverter.class);
            return (IPropertyConverter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to load conversion class! " + converterClass, e);
        }
    }

    protected static IProperty variableProperty(IPropertyGroup group, String name, String description, String variable) {
        IProperty prop = Property.registry().registerProperty(group, name, "string", description);
        return MakefileExternalOptions.variableProperty(prop, variable);
    }

    protected static IProperty variableProperty(IProperty prop, String variable) {
        ((IWriteableDescriptor)prop).setProperty(MAKEFILE_CONVERTER, (Object)StringTemplatePropertyConverter.class.getName());
        ((IWriteableDescriptor)prop).setProperty(StringTemplatePropertyConverter.VARIABLE_REPL, (Object)variable);
        return prop;
    }
}

