/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile.options;

import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileOptionMappingUtils;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.function.Function;

public final class MakefileCommonGccGenericOptionMappings<T> {
    private IGenericOptionMappingRegistry makefileGccOptionMappingRegistry;
    private MakefileOptionMappingUtils<T> mapper;

    public MakefileCommonGccGenericOptionMappings(IGenericOptionMappingRegistry makefileGccOptionMappingRegistry, MakefileOptionMappingUtils<T> mapper) {
        this.makefileGccOptionMappingRegistry = makefileGccOptionMappingRegistry;
        this.mapper = mapper;
    }

    public void mapCommonWarnings(Function<T, IProperty> all, Function<T, IProperty> extra, Function<T, IProperty> pedantic, Function<T, IProperty> areErrors) {
        this.mapCompilerWarningsAll(all);
        this.mapCompilerWarningsExtra(extra);
        this.mapCompilerWarningsPedantic(pedantic);
        this.mapCompilerWarningsAreErrors(areErrors);
    }

    private void mapCompilerWarningsAll(Function<T, IProperty> optMapper) {
        this.mapper.mapCxxOptions(optMapper, (f, g) -> this.doMap((GenericOptionMappingFactory)f, "-Wall", g.Warnings().INCORRECT_CODE));
    }

    private void mapCompilerWarningsExtra(Function<T, IProperty> optMapper) {
        this.mapper.mapCxxOptions(optMapper, (f, g) -> this.doMap((GenericOptionMappingFactory)f, "-Wextra", g.Warnings().EXTRA));
    }

    private void mapCompilerWarningsPedantic(Function<T, IProperty> optMapper) {
        this.mapper.mapCxxOptions(optMapper, (f, g) -> this.doMap((GenericOptionMappingFactory)f, "-Wpedantic", g.Warnings().NON_STANDARD));
    }

    private void mapCompilerWarningsAreErrors(Function<T, IProperty> optMapper) {
        this.mapper.mapCxxOptions(optMapper, (f, g) -> this.doMap((GenericOptionMappingFactory)f, "-Werror", g.Warnings().WARNINGS_ARE_ERRORS));
    }

    private void doMap(GenericOptionMappingFactory f, String specific, IProperty prop) {
        f.forSpecific((Object)specific).mapTrue(new IProperty[]{prop}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)this.makefileGccOptionMappingRegistry);
    }
}

