/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyConverter;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTemplatePropertyConverter
implements IPropertyConverter {
    public static final PropertyReference<String> VARIABLE_REPL = CoreTypes.STRING.property("variableRepl");
    private static final String VALUE_REPL = "$(value)";

    public Object createFromString(IProperty property, String value, IDescriptor context) throws IllegalArgumentException {
        String variableStr = (String)property.getProperty(VARIABLE_REPL);
        if (TextUtils.isEmpty((String)variableStr)) {
            throw new IllegalStateException("Property should have regex property! " + String.valueOf(property));
        }
        Matcher matcher = Pattern.compile(variableStr.replace(VALUE_REPL, "(.*)")).matcher(String.valueOf(value));
        if (!matcher.matches()) {
            return value;
        }
        return matcher.group(1);
    }

    public String convertToString(IProperty property, Object value, IDescriptor context) throws IllegalArgumentException {
        String variableStr = (String)property.getProperty(VARIABLE_REPL);
        if (TextUtils.isEmpty((String)variableStr)) {
            throw new IllegalStateException("Property should have regex property! " + String.valueOf(property));
        }
        return variableStr.replace(VALUE_REPL, value == null ? "" : String.valueOf(value));
    }
}

