/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Node;

public class StringListOption
extends BaseIAROption<Collection<String>> {
    public StringListOption(Node optionNode) {
        super(optionNode);
    }

    public void appendState(String stateVal, boolean replace) {
        if (replace && this.getStateList().contains(stateVal)) {
            this.removeNode(stateVal);
        }
        Node newNode = this.createStateNode(stateVal);
        this.appendNode(newNode);
    }

    public void clearStateList() {
        this.removeNodes(t -> true);
    }

    public void removeNodes(Predicate<String> shouldRemove) {
        new ArrayList<String>(this.getStateList()).stream().filter(shouldRemove::test).forEach(this::removeNode);
    }

    @Override
    public List<String> getValue() {
        return this.getStateList();
    }

    @Override
    protected Collection<String> convertToStringList(Object value) {
        return StringListOption.convertStringList(value);
    }

    static Collection<String> convertStringList(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(String::valueOf).collect(Collectors.toList());
        }
        if (value == null) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(String.valueOf(value));
    }
}

