/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectContentContainer;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAREntry;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARFile;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Node;

public class IARContentContainer
extends IAREntry
implements IExternalProjectContentContainer {
    private static final String ELEMENT_GROUP = "group";
    private static final String ELEMENT_FILE = "file";
    private List<IARGroup> groups = new ArrayList<IARGroup>();
    private List<IARFile> files = new ArrayList<IARFile>();

    public IARContentContainer(Node contentNode, IPath projectFolder, ImporterTool.ToolchainID projectToolchainID) {
        super(contentNode, projectFolder, projectToolchainID);
    }

    public void addGroupsAndFiles(Map<String, String> replacements, ImporterTool.ToolchainID projectToolchainID) {
        for (Node groupNode : this.childNodes().get((Object)ELEMENT_GROUP)) {
            this.groups.add(new IARGroup(groupNode, this.projectFolder(), replacements, projectToolchainID));
        }
        for (Node fileNode : this.childNodes().get((Object)ELEMENT_FILE)) {
            this.files.add(new IARFile(fileNode, this.projectFolder(), replacements, projectToolchainID));
        }
    }

    public boolean remove(IAREntry entry) {
        Node entryNode = entry.getNode();
        boolean removed = this.groups.remove(entry);
        removed |= this.files.remove(entry);
        boolean canRemove = false;
        int i = 0;
        while (i < this.getNode().getChildNodes().getLength()) {
            Node node = this.getNode().getChildNodes().item(i);
            if (Objects.equals(node, entryNode)) {
                canRemove = true;
                break;
            }
            ++i;
        }
        if (canRemove) {
            this.getNode().removeChild(entryNode);
        }
        return removed;
    }

    public IARGroup addGroup(String groupName) {
        Node groupNode = this.createSubNode(groupName, ELEMENT_GROUP, "name");
        IARGroup group = new IARGroup(groupNode, this.projectFolder().append(groupName), this.getVariableReplacements(), this.projectToolchainID());
        this.groups.add(group);
        return group;
    }

    public IARFile addFile(String filePath) {
        Node fileNode = this.createSubNode(filePath, ELEMENT_FILE, "name");
        IARFile file = new IARFile(fileNode, this.projectFolder(), this.getVariableReplacements(), this.projectToolchainID());
        this.files.add(file);
        return file;
    }

    public List<IARFile> getChildFiles() {
        return this.files;
    }

    public List<IARGroup> getChildFolders() {
        return this.groups;
    }
}

