/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectConfiguration;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.internal.api.core.external.impl.PropertyInfo;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARFlagParser;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwp8051ExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpArmExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARBuildActions;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARChipSelect;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARIncludePaths;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARLibraries;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARMacroDefinitions;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAROptionFactory;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAROutputFile;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAROutputName;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IIARConfigurationInfo;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwpModelUtils;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Node;

public class IARConfiguration
extends IARElement
implements IExternalProjectConfiguration {
    private static final Set<IProperty> miscOptions = Stream.of(IarEwpArmExternalOptions.ASSEMBLER_MISC, IarEwpArmExternalOptions.COMPILER_MISC, IarEwpArmExternalOptions.LINKER_MISC).map(PropertyInfo::getProperty).collect(Collectors.toSet());
    private Map<String, BaseIAROption<?>> options;
    List<MBuildSetting> buildSettings;
    IIARConfigurationInfo configInfo;
    Map<String, String> variableReplacements;
    private IARChipSelect partSelection;
    private IAROutputName outputName;
    private IAROutputFile outputFile;
    private IPath projectFolder;
    private Set<String> unconvertedVariables = new HashSet<String>();
    private IARFlagParser parser;
    private IARIncludePaths includePaths;
    private IARMacroDefinitions macros;
    private IARLibraries libraries;
    private IARBuildActions buildActions;

    public IARConfiguration(Node configNode, IPath projectFolder, Map<String, String> replacements, ImporterTool.ToolchainID projectToolchainID) {
        super(configNode);
        ImporterTool.ToolchainID toolchain;
        this.options = new HashMap();
        this.buildSettings = new ArrayList<MBuildSetting>();
        this.variableReplacements = this.getConfigurationVariables(replacements);
        this.projectFolder = projectFolder;
        if (projectToolchainID == null) {
            if (this.childNodes().containsKey((Object)"toolchain")) {
                Node toolchainNode = (Node)this.childNodes().get((Object)"toolchain").get(0);
                IARElement toolchainElement = new IARElement(toolchainNode);
                toolchain = IarEwpModelUtils.getToolchainID(toolchainElement.getName());
            } else {
                toolchain = ImporterTool.ToolchainID.ARM;
            }
            projectToolchainID = toolchain;
        } else {
            toolchain = projectToolchainID;
        }
        if (toolchain == ImporterTool.ToolchainID.ARM) {
            this.configInfo = new IarEwpArmExternalOptions();
        } else if (toolchain == ImporterTool.ToolchainID.EIGHTYFIFTYONE) {
            this.configInfo = new IarEwp8051ExternalOptions();
        }
        this.parser = new IARFlagParser(this.configInfo);
        for (Node settingsNode : this.childNodes().get((Object)"settings")) {
            ImporterTool.ToolType toolType;
            IARElement settingsElement = new IARElement(settingsNode);
            String toolName = settingsElement.getName();
            if ("BUILDACTION".equals(toolName)) {
                this.buildActions = new IARBuildActions(this, settingsElement);
                continue;
            }
            if (toolName.equals(this.configInfo.getCompilerTool())) {
                toolType = ImporterTool.ToolType.COMPILER;
            } else if (toolName.equals(this.configInfo.getAssemblerTool())) {
                toolType = ImporterTool.ToolType.ASSEMBLER;
            } else if (toolName.equals(this.configInfo.getLinkerTool())) {
                toolType = ImporterTool.ToolType.LINKER;
            } else {
                if (!"General".equals(toolName) && !"OBJCOPY".equals(toolName)) continue;
                toolType = ImporterTool.ToolType.TOOLCHAIN;
            }
            this.addOptions(settingsElement, toolType, projectFolder);
        }
        this.updateOptionsList();
    }

    public void formatForImport() {
        this.replaceVariablesInOptions();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        ((Node)this.childNodes().get((Object)"name").get(0)).setTextContent(name);
    }

    public Set<String> getUnconvertedVariables() {
        Set<String> unconvertedVariables = this.options.values().stream().map(BaseIAROption::getUnconvertedVariables).flatMap(Collection::stream).collect(Collectors.toSet());
        unconvertedVariables.addAll(this.parser.getUnconvertedVariables());
        unconvertedVariables.addAll(this.unconvertedVariables);
        return unconvertedVariables;
    }

    private Map<String, String> getConfigurationVariables(Map<String, String> replacements) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(replacements);
        map.put("$CONFIG_NAME$", this.getName());
        return map;
    }

    private void replaceVariablesInOptions() {
        for (BaseIAROption<?> opt : this.options.values()) {
            if (miscOptions.contains(opt.getProperty())) continue;
            opt.replaceInStateList(this.variableReplacements);
        }
    }

    public ImporterTool.ToolchainID getToolchain() {
        return this.configInfo.toolchain();
    }

    public Collection<BaseIAROption<?>> getOptions() {
        return this.options.values();
    }

    public Map<String, BaseIAROption<?>> getOptionMap() {
        return this.options;
    }

    public List<MBuildSetting> getBuildSettings() {
        return this.buildSettings;
    }

    public IARChipSelect getPart() {
        return this.partSelection;
    }

    public IAROutputName getOutputName() {
        return this.outputName;
    }

    public IAROutputFile getOutputFile() {
        return this.outputFile;
    }

    public IPath projectFolder() {
        return this.projectFolder;
    }

    public IARIncludePaths includes() {
        return this.includePaths;
    }

    public IARMacroDefinitions macros() {
        return this.macros;
    }

    public IARLibraries libraries() {
        return this.libraries;
    }

    public IARBuildActions buildActions() {
        return this.buildActions;
    }

    private void updateOptionsList() {
        this.includePaths = new IARIncludePaths(this);
        this.buildSettings.addAll(this.includePaths.convert());
        this.macros = new IARMacroDefinitions(this);
        this.buildSettings.addAll(this.macros.convert());
        this.libraries = new IARLibraries(this);
        this.buildSettings.addAll(this.libraries.convert());
        this.partSelection = new IARChipSelect(this);
        this.outputName = new IAROutputName(this);
        this.outputFile = new IAROutputFile(this);
    }

    public BaseIAROption<?> findOption(String optionName) {
        return this.options.get(optionName);
    }

    BaseIAROption<?> getAndClear(String optionName) {
        return this.options.remove(optionName);
    }

    protected void addOptions(IARElement settingsElement, ImporterTool.ToolType toolType, IPath projectFolder) {
        for (Node dataNode : settingsElement.childNodes().get((Object)"data")) {
            IARElement dataElement = new IARElement(dataNode);
            for (Node optionNode : dataElement.childNodes().get((Object)"option")) {
                List<BaseIAROption<?>> optionsList = IAROptionFactory.makeOptions(optionNode, toolType, projectFolder, this.configInfo);
                for (BaseIAROption<?> option : optionsList) {
                    this.options.put(option.getId(), option);
                }
            }
        }
    }
}

