/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectOption;
import com.silabs.ss.framework.project.internal.api.core.external.impl.PropertyInfo;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectImporter;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARVersion;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaseIAROption<T>
extends IARElement
implements IExternalProjectOption {
    protected static final String ELEMENT_STATE = "state";
    private IARVersion version;
    private LinkedList<String> stateList;
    private IProperty property;
    private boolean haveCheckedVariables = false;
    private Set<String> unconvertedVariables = new HashSet<String>();

    public BaseIAROption(Node optionNode) {
        super(optionNode);
        this.stateList = this.getStateNodes().stream().map(Node::getTextContent).filter(TextUtils::hasContent).collect(Collectors.toCollection(LinkedList::new));
        this.version = new IARVersion(this);
    }

    public Set<String> getUnconvertedVariables() {
        return this.unconvertedVariables;
    }

    public String getId() {
        return PropertyInfo.generateId(this.getName(), this.getVersion());
    }

    public String getVersion() {
        return this.version.getVersion();
    }

    public IProperty getProperty() {
        this.findUnconvertedVariables();
        return this.property;
    }

    public void setProperty(IProperty property) {
        this.property = property;
    }

    public List<String> getStateList() {
        return this.stateList;
    }

    public void setValue(Object value) {
        Collection<String> convertedOpt = this.convertToStringList(value);
        ArrayList<String> allStates = new ArrayList<String>(this.getStateList());
        if (convertedOpt.size() == allStates.size() && convertedOpt.containsAll(allStates)) {
            return;
        }
        allStates.forEach(this::removeNode);
        this.clearEmptyNodes();
        convertedOpt.stream().map(this::createStateNode).forEach(this::appendNode);
    }

    protected Collection<String> convertToStringList(Object value) {
        return new ArrayList<String>(this.getStateList());
    }

    public T getValue() {
        return null;
    }

    protected List<Node> getStateNodes() {
        return this.childNodes().get((Object)ELEMENT_STATE);
    }

    protected Node createStateNode(String value) {
        Element stateOpt = this.getNode().getOwnerDocument().createElement(ELEMENT_STATE);
        stateOpt.setTextContent(value);
        return stateOpt;
    }

    protected void appendNode(Node node) {
        if (this.spaceNode != null) {
            this.insertNode(this.spaceNode.cloneNode(true));
        }
        this.insertNode(node);
        this.getStateList().add(node.getTextContent());
    }

    private void insertNode(Node node) {
        if (this.insertionNode == null) {
            this.getNode().appendChild(node);
        } else {
            this.getNode().insertBefore(node, this.insertionNode);
        }
    }

    protected void clearEmptyNodes() {
        while (this.removeNode("")) {
        }
    }

    protected boolean removeNode(String textContent) {
        this.stateList.removeLastOccurrence(textContent);
        Optional<Node> removeNode = Optional.empty();
        Optional<Node> textNode = Optional.empty();
        int i = 0;
        while (i < this.getNode().getChildNodes().getLength()) {
            Node node = this.getNode().getChildNodes().item(i);
            if (textContent.equals(node.getTextContent())) {
                Node nextNode;
                removeNode = Optional.of(node);
                if (i - 1 != -1 && (nextNode = this.getNode().getChildNodes().item(i - 1)).getTextContent().trim().isEmpty()) {
                    textNode = Optional.of(nextNode);
                }
            }
            ++i;
        }
        int nodeLen = this.getNode().getChildNodes().getLength();
        textNode.ifPresent(this.getNode()::removeChild);
        removeNode.ifPresent(this.getNode()::removeChild);
        return this.getNode().getChildNodes().getLength() != nodeLen;
    }

    @Override
    public Collection<IProperty> getIProperties() {
        ArrayList<IProperty> properties = new ArrayList<IProperty>();
        properties.add(this.property);
        this.findUnconvertedVariables();
        return properties;
    }

    public void replaceInStateList(Map<String, String> replacements) {
        this.stateList = new LinkedList<String>(ProjectImportUtils.replaceVariablesInList(this.stateList, replacements));
        this.findUnconvertedVariables();
    }

    private void findUnconvertedVariables() {
        if (!this.haveCheckedVariables && this.property != null) {
            for (String string : this.stateList) {
                this.unconvertedVariables.addAll(ProjectImportUtils.findAllPatternMatches(string, IARExternalProjectImporter.VARIABLE_PATTERN));
            }
        }
    }

    public String toString() {
        return this.getId() + " " + this.getStateList().toString();
    }
}

