/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.google.common.collect.ImmutableSet;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.type.ExternalProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectToolOptionHandler;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeInfo;
import com.silabs.ss.framework.project.api.core.type.ProjectTypeData;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectType;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARGenericOptionsMappings;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwwSolutionOperationHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class IarEwpProjectType
extends ExternalProjectType {
    private static final ImmutableSet<String> IAR_EWP_EXTENSIONS = ImmutableSet.of((Object)"ewp", (Object)"ipcf", (Object)"eww", (Object)"ewd");
    private static final ImmutableSet<String> IAR_EWP_SOLUTION_EXTENSIONS = ImmutableSet.of((Object)"eww");

    @Override
    public Collection<String> matchingKeywords() {
        return Arrays.asList("iar", "IAR", "ewp", "IAR Embedded Workbench");
    }

    @Override
    public double getApplicability(IPath projLoc) throws CoreException {
        String ext = projLoc.getFileExtension();
        if (IAR_EWP_EXTENSIONS.contains((Object)ext)) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public boolean toolchainSupportsProject(IToolchainDescriptor toolchain, IProjectDescriptor desc) {
        return false;
    }

    @Override
    public IProjectEngineOperationHandler createProjectEngineOperationHandler(IProjectEntity project) {
        if (!(project instanceof IExternalProjectEntity)) {
            throw new IllegalArgumentException("IAR ewp generation requires an IExternalProjectEntity");
        }
        return new IarEwpOperationHandler((IExternalProjectEntity)project);
    }

    @Override
    public ISolutionEngineOperationHandler createSolutionEngineOperationHandler(ISolutionEntity solution) {
        return new IarEwwSolutionOperationHandler(solution);
    }

    @Override
    public IExternalType getExternalType() {
        return new IARExternalProjectType();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (IProjectToolOptionHandler.class.equals(clazz)) {
            return clazz.cast(new IarEwpToolOptionHandler());
        }
        if (IProjectTypeInfo.class.equals(clazz)) {
            return clazz.cast(new IarEwpProjectTypeInfo());
        }
        if (ProjectTypeData.class.equals(clazz)) {
            return clazz.cast(this.projectTypeData());
        }
        return super.getAdapter(clazz);
    }

    private ProjectTypeData projectTypeData() {
        return ProjectTypeData.data().supportsSolutionBuildSteps(false).create();
    }

    @Override
    public Collection<File> getSupportedFiles(IProjectDescriptor desc, File directory, String baseName) {
        String tcCompat = desc.getPropertyAccess().getValueString(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
        if (TextUtils.hasContent((String)tcCompat) && !tcCompat.contains("iar")) {
            return Collections.emptyList();
        }
        String core = (String)desc.getProperty(ProjectProperties.ALLOWED_CORE_ARCHITECTURE);
        if (!"ARM".equals(core) && !"8051".equals(core)) {
            return Collections.emptyList();
        }
        return this.doGetSupportFiles((Collection<String>)IAR_EWP_EXTENSIONS, directory, baseName);
    }

    @Override
    public Collection<File> getSupportedSolutions(ISolutionDescriptor slnDesc, File directory, String baseName) {
        return this.doGetSupportFiles((Collection<String>)IAR_EWP_SOLUTION_EXTENSIONS, directory, baseName);
    }

    private Collection<File> doGetSupportFiles(Collection<String> extensions, File directory, String baseName) {
        if (extensions.stream().anyMatch(directory.getName()::endsWith)) {
            return Arrays.asList(directory);
        }
        List<File> supportedFiles = extensions.stream().map(e -> new File(directory, baseName + "." + e)).collect(Collectors.toList());
        return supportedFiles;
    }

    private class IarEwpProjectTypeInfo
    implements IProjectTypeInfo {
        private IarEwpProjectTypeInfo() {
        }

        @Override
        public String ideCompatibilityId() {
            return "iar-embedded-workbench";
        }
    }

    private class IarEwpToolOptionHandler
    implements IProjectToolOptionHandler {
        private IarEwpToolOptionHandler() {
        }

        @Override
        public Collection<IGenericOptionMappingRegistry> getGenericOptionMappingRegistry(IProjectDescriptor proj, ISelectableDescriptor context) {
            return Arrays.asList(IARGenericOptionsMappings.iarOptionMappingRegistry);
        }
    }
}

