/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.ss.framework.project.api.core.external.IToolchainDirectImportSupport;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.options.DirectOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingRegistryFactory;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpArmExternalOptions;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;

public class IARDirectOptionsMapping {
    public static final String IAR_TOOLCHAIN = "com.silabs.ss.tool.ide.arm.toolchain.iar";
    private static IDirectOptionMappingRegistry iarOptionMappingRegistry;
    private static IToolchainDirectImportSupport tcSupport;

    public static IDirectOptionMappingRegistry registry() {
        if (iarOptionMappingRegistry == null) {
            iarOptionMappingRegistry = OptionMappingRegistryFactory.INSTANCE.createDirectOptionMappingRegistry();
            if (IARDirectOptionsMapping.validateTcSupport()) {
                IARDirectOptionsMapping.setupMappingRegistry();
            }
        }
        return iarOptionMappingRegistry;
    }

    private static IProperty cdtOption(IARPropGroup propGroup, String optionID) {
        IPropertyGroup group = propGroup.getProperty();
        if (group == null) {
            return null;
        }
        return group.findProperty(optionID);
    }

    private static void initToolchainSupport() {
        if (tcSupport != null) {
            return;
        }
        IToolchain iarTc = (IToolchain)Toolchain.manager().findCompatible(IAR_TOOLCHAIN);
        if (iarTc != null) {
            tcSupport = (IToolchainDirectImportSupport)iarTc.getAdapter(IToolchainDirectImportSupport.class);
        }
        if (tcSupport == null) {
            tcSupport = IToolchainDirectImportSupport.NONE_TOOLCHAIN_IMPORT_SUPPORT;
        }
    }

    private static boolean validateTcSupport() {
        IARPropGroup[] iARPropGroupArray = IARPropGroup.values();
        int n = iARPropGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            IARPropGroup propGroup = iARPropGroupArray[n2];
            if (propGroup.getProperty() == null || propGroup.getProperty().getProperties().length == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void unmapped(IProperty property) {
        DirectOptionMappingFactory.with((IProperty)property).is(EMappingStatus.UNMAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
    }

    private static void setupMappingRegistry() {
        try {
            IarEwpArmExternalOptions armOpts = new IarEwpArmExternalOptions();
            armOpts.getPropertyInfo("Output variant", "2", ImporterTool.ToolType.TOOLCHAIN).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.printfFormatter.v5.4.0"), new Object[]{"0", "iar.arm.toolchain.comon.option.printfFormatter.auto.v6.2.2", "1", "iar.arm.toolchain.comon.option.printfFormatter.full.v5.4.0", "2", "iar.arm.toolchain.comon.option.printfFormatter.full.v5.4.0", "3", "iar.arm.toolchain.option.printfFormatter.large.v5.4.0", "4", "iar.arm.toolchain.option.printfFormatter.large.v5.4.0", "5", "iar.arm.toolchain.option.printfFormatter.small.v5.4.0", "6", "iar.arm.toolchain.option.printfFormatter.small.v5.4.0", "7", "iar.arm.toolchain.option.printfFormatter.tiny.v5.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.deviceName.v5.5.0"));
            armOpts.getPropertyInfo("IlinkConfigDefines", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.configSymbolDefs.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IccCppInlineSemantics", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.cppInlineSemantics.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AExtraOptionsV2", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.extraOptions.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.overrideDefaultOutputFile.v5.5.2"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.endian.v5.4.0"));
            armOpts.getPropertyInfo("CCPosIndRopi", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.ropi.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("StaticClustering", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optStaticClustering.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkDebugInfoEnable", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.stripDebugInformation.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.fpu.v5.4.0"));
            armOpts.getPropertyInfo("IlinkStackControlFile", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.stackUsageControlFile.v6.3.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.misra-c.option"));
            armOpts.getPropertyInfo("CCPosIndNoDynInit", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.noRwDynamicInit.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCCodeSection", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.codeSection.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.deviceTag.v6.3.1"));
            armOpts.getPropertyInfo("ADefines", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.definedSymbols.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.lowLevelInterface.v5.4.0"));
            armOpts.getPropertyInfo("GRuntimeLibSelect", "0", ImporterTool.ToolType.TOOLCHAIN).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.libraryConfig.v5.4.0"), new Object[]{"1", "iar.arm.toolchain.option.libraryConfig.none.v5.4.0", "2", "iar.arm.toolchain.option.libraryConfig.normal.v5.4.0", "3", "iar.arm.toolchain.option.libraryConfig.full.v5.4.0", "4", "iar.arm.toolchain.option.libraryConfig.custom.v5.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkOverrideProgramEntryLabel", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.entryOverride.v6.2.3")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("Input variant", "3", ImporterTool.ToolType.TOOLCHAIN).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.scanfFormatter.v5.4.0"), new Object[]{"0", "iar.arm.toolchain.option.scanfFormatter.auto.v6.2.2", "1", "iar.arm.toolchain.option.scanfFormatter.full.v5.4.0", "2", "iar.arm.toolchain.option.scanfFormatter.full.v5.4.0", "3", "iar.arm.toolchain.option.scanfFormatter.large.v5.4.0", "4", "iar.arm.toolchain.option.scanfFormatter.large.v5.4.0", "5", "iar.arm.toolchain.option.scanfFormatter.small.v5.4.0", "6", "iar.arm.toolchain.option.scanfFormatter.small.v5.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcUnitSize", "0", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumUnitSize.v6.4.0"), new Object[]{"0", "iar.arm.toolchain.linker.option.checksumUnitSize.8bit.v6.4.0", "1", "iar.arm.toolchain.linker.option.checksumUnitSize.16bit.v6.4.0", "2", "iar.arm.toolchain.linker.option.checksumUnitSize.32bit.v6.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AList", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.generateListFile.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("OGBufferedTerminalOutput", "", ImporterTool.ToolType.TOOLCHAIN).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.bufferedOutput.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AltRegisterNames", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.alternativeRegisterNames.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkOptInline", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.inline.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCSignedPlainChar", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.charIs.v6.1.0"), new Object[]{"0", "iar.arm.toolchain.compiler.option.charIs.signed.v6.1.0", "1", "iar.arm.toolchain.compiler.option.charIs.unsigned.v6.1.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCDiagSuppress", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.suppress.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IProcessorMode2", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.cpuMode.v5.4.0"), new Object[]{"0", "iar.arm.toolchain.compiler.option.cpuMode.thumb.v5.4.0", "1", "iar.arm.toolchain.compiler.option.cpuMode.arm.v5.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkAutoLibEnable", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.autoLibrarySelection")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.cpu.v5.4.0"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.cpu.v5.4.0"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.outFormat.v5.5.2"));
            armOpts.getPropertyInfo("IccAllowVLA", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.enableVLA.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCOptLevel", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optLevel.v5.4.0"), new Object[]{"0", "iar.arm.toolchain.compiler.option.optLevel.none.v5.4.0", "1", "iar.arm.toolchain.compiler.option.optLevel.low.v5.4.0", "2", "iar.arm.toolchain.compiler.option.optLevel.medium.v5.4.0", "None", "iar.arm.toolchain.compiler.option.optLevel.highSize.v5.4.0", "3", "iar.arm.toolchain.compiler.option.optLevel.highBalance.v5.4.0", "None", "iar.arm.toolchain.compiler.option.optLevel.highSpeed.v5.4.0"}).is(EMappingStatus.PARTIALLY_MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCPreprocLine", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.generateLineDirectives.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkProgramEntryLabel", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.programEntry.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCLangConformance", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.languageConformance.v6.1.0"), new Object[]{"0", "iar.arm.toolchain.compiler.option.languageConformance.iarExtensions.v6.1.0", "1", "iar.arm.toolchain.compiler.option.languageConformance.standard.v6.1.0", "2", "iar.arm.toolchain.compiler.option.languageConformance.strict.v6.1.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AListHeader", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.omitHeader.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("ADebug", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.debugInfo.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkDefines", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.define.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CommonSubexpressionElimination", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optCSE.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("ACaseSensitivity", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.caseSensitiveSymbols.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.bigEndianFormat.v5.4.0"));
            armOpts.getPropertyInfo("IlinkLogSection", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileSectionSelections.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("ALimitErrorsEdit", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.maxErrors.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCOptimizationNoSizeConstraints", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.noSizeConstraints.v6.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkLogUnusedFragments", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileUnusedFragments.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("Includes", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.includeInclude.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("MacDefs", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.includeMacroDefinitions.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("MacroChars", "0", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.quoteCharacters.v5.4.0"), new Object[]{"1", "iar.arm.toolchain.assembler.option.quoteCharacters.bracket.v5.4.0", "2", "iar.arm.toolchain.assembler.option.quoteCharacters.squareBracket.v5.4.0", "3", "iar.arm.toolchain.assembler.option.quoteCharacters.curlyBracket.v5.4.0", "0", "iar.arm.toolchain.assembler.option.quoteCharacters.angleBracket.v5.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkTreatAsRem", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.treatAsRemarks.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("FillerEnd", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.fillEnd.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCEnableRemarks", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.enableRemarks.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("OnlyAssed", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.includeAsmLinesOnly.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IExtraOptions", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.additionalUserOptions")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkExtraOptions", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.extraOptions.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.disableWarnings.v5.4.0"));
            armOpts.getPropertyInfo("IccCppDialect", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.cppdialect.v6.1.0"), new Object[]{"1", "iar.arm.toolchain.compiler.option.cppdialect.ecpp.v6.1.0", "0", "iar.arm.toolchain.compiler.option.cppdialect.eecpp.v6.1.0", "2", "iar.arm.toolchain.compiler.option.cppdialect.full.v6.1.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.icfFile.v5.4.0"));
            armOpts.getPropertyInfo("IlinkWarningsAreErrors", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.warningsAreErrors.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkTreatAsErr", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.treatAsErrors.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcAlign", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumAlignment.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCDiagRemark", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.treatAsRemarks.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkLogModule", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileModuleSelections.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkSuppressDiags", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.suppressThese.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("FunctionInlining", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optInline.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("RTConfigPath2", "", ImporterTool.ToolType.TOOLCHAIN).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.libraryConfigFile.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkCrcUseAsInput", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.useAsInput.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcAlgorithm", "0", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumType.v5.5.2"), new Object[]{"0", "iar.arm.toolchain.linker.option.checksumType.arithmeticSum.v5.5.2", "1", "iar.arm.toolchain.linker.option.checksumType.crc16.v5.5.2", "2", "iar.arm.toolchain.linker.option.checksumType.crc32.v5.5.2", "3", "iar.arm.toolchain.linker.option.checksumType.crcPolynomial.v5.5.2", "4", "iar.arm.toolchain.linker.option.checksumType.crc64ISO.v6.4.0", "5", "iar.arm.toolchain.linker.option.checksumType.crc64ECMA.v6.4.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCPreprocFile", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.preprocessorOut.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AXRefInternal", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.crossRefInternalSymbols.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.discardUnusedPublics.v5.5.2"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.generateAdditonalOutput.v5.5.2"));
            armOpts.getPropertyInfo("AXRefDefines", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.crossRefDefines.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCDiagError", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.treatAsErrors.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.useDSPLibrary.v6.2.2"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.wrapDiagnostics"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.cmsis.v5.4.0"));
            armOpts.getPropertyInfo("IlinkEnableRemarks", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.enableRemarks.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.fpu.v5.4.0"));
            armOpts.getPropertyInfo("IlinkStackCallGraphFile", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.callGraphOutput.v6.3.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("FillerStart", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.fillStart.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkLogFile", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFile.v6.2.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcPoly", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumCrcPolynomial.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcSize", "0", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumSize.v5.5.2"), new Object[]{"0", "iar.arm.toolchain.linker.option.checksumSize.1byte.v5.5.2", "1", "iar.arm.toolchain.linker.option.checksumSize.2bytes.v5.5.2", "2", "iar.arm.toolchain.linker.option.checksumSize.4bytes.v5.5.2"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCRequirePrototypes", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.requirePrototypes.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCMultibyteSupport", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.multibyte.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AWarnEnable", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.disableAllWarnings.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IccExceptions", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.noExceptions.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCDiagWarnAreErr", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.treatAllWarningsAsErrors.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkLogVeneer", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileVeenerStatistics.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.endianMode.v5.4.0"));
            armOpts.getPropertyInfo("IccRTTI", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.noRTTI.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("PageLength", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.linesPerPage.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.misra-c.enable"));
            armOpts.getPropertyInfo("IlinkOptMergeDuplSections", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.mergeDuplicateSections.v6.2.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.cpuCore.v5.4.0"));
            armOpts.getPropertyInfo("IlinkMapFile", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.mapFile.v6.2.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCStdIncCheck", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.ignoreStdInc.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcBitOrder", "0", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.bitOrder.v5.5.2"), new Object[]{"0", "iar.arm.toolchain.linker.option.bitOrder.MSBfirst.v5.5.2", "1", "iar.arm.toolchain.linker.option.bitOrder.LSBfirst.v5.5.2"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IccFloatSemantics", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.relaxedFp.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IccLang", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.language.v6.1.0"), new Object[]{"0", "iar.arm.toolchain.compiler.option.language.c.v6.1.0", "1", "iar.arm.toolchain.compiler.option.language.cpp.v6.1.0", "2", "iar.arm.toolchain.compiler.option.language.auto.v6.2.2"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.semihosted.v5.4.0"));
            armOpts.getPropertyInfo("MultiLine", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.includeMultilineCode.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("DoFill", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.fill.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AMultibyteSupport", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.enableMultibyte.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcFullSize", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumResultFullSize.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.mfc.v5.5.2"));
            armOpts.getPropertyInfo("IlinkLogAutoLibSelect", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileLibrarySelections.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkLogInitialization", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileInitializationDecisions.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AIgnoreStdInclude", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.ignoreStdInc.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("FillerByte", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.fillPattern.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.fpu.v5.4.0"));
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.useCMSIS.v6.2.2"));
            armOpts.getPropertyInfo("PreInclude", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.preincludeFile.v6.2.12")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.lowLevelInterfaceCortex.v5.4.0"));
            armOpts.getPropertyInfo("IlinkKeepSymbols", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.keep.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCPosIndRwpi", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.rwpi.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("TypeBasedAliasAnalysis", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optAliasAnalysis.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCDiagWarning", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.treatAsWarnings.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CodeMotion", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optCodeMotion.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkOptExceptionsAllow", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.noExceptions.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("TabSpacing", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.tabSpacing.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IccStaticDestr", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.destroyStaticObjects.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AXRefDual", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.crossRefDualLineSpacing.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("LoopUnrolling", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optUnroll.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("AListing", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.asmListContents.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkOptExceptionsForce", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.forceExceptions.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("DoCrc", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.generateChecksum.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.listFile.v5.4.0"));
            armOpts.getPropertyInfo("IlinkOptUseVfe", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.performVFE.v6.2.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.dlibConfig.v5.4.0"));
            armOpts.getPropertyInfo("IlinkAdditionalLibs", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.additionalLibraries.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.altOutputFile.v5.5.2"));
            armOpts.getPropertyInfo("MacExps", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.includeMacroExpansions.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkStackAnalysisEnable", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.enableStackUsage.v6.3.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkRawBinaryFile", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.imageInput.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.deviceInfo.v5.4.3"));
            armOpts.getPropertyInfo("InstructionScheduling", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.optScheduling.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IccCDialect", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.cdialect.v6.1.0"), new Object[]{"0", "iar.arm.toolchain.compiler.option.cdialect.c89.v6.1.0", "1", "iar.arm.toolchain.compiler.option.cdialect.c99.v6.1.0"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.misra-c.enable98"));
            armOpts.getPropertyInfo("IlinkProgramEntryLabelSelect", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.entryDefinedByApplication.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.toolchain, "iar.arm.toolchain.option.discardUnusedPublics.v5.5.2"));
            armOpts.getPropertyInfo("IlinkTreatAsWarn", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.treatAsWarnings.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IInterwork2", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.interwork.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkLogRedirSymbols", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.logFileRedirectedSymbols.v5.5.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkCrcReverseByteOrder", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.checksumReverse.v6.1.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.asmFile.v5.4.0"));
            armOpts.getPropertyInfo("CCPreprocComments", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.preserveComments.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CCDebugInfo", "", ImporterTool.ToolType.COMPILER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.debugInfo.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcCompl", "0", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapFromTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.complement.v5.5.2"), new Object[]{"0", "iar.arm.toolchain.linker.option.complement.asIs.v5.5.2", "1", "iar.arm.toolchain.linker.option.complement.1complement.v5.5.2", "2", "iar.arm.toolchain.linker.option.complement.2complement.v5.5.2"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("CrcInitialValue", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.initialValue.v5.5.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.enableWarnings.v5.4.0"));
            armOpts.getPropertyInfo("AXRef", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.asmCrossReference.v6.2.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("MacExec", "", ImporterTool.ToolType.ASSEMBLER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.assembler, "iar.arm.toolchain.assembler.option.includeMacroInfo.v5.4.0")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            armOpts.getPropertyInfo("IlinkOptForceVfe", "", ImporterTool.ToolType.LINKER).createNewDirectMappingFactory().mapTo(IARDirectOptionsMapping.cdtOption(IARPropGroup.linker, "iar.arm.toolchain.linker.option.forceVFE.v6.2.2")).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)iarOptionMappingRegistry);
            IARDirectOptionsMapping.unmapped(IARDirectOptionsMapping.cdtOption(IARPropGroup.compiler, "iar.arm.toolchain.compiler.option.mfc.v5.5.2"));
        }
        catch (Exception e) {
            Activator.reporter.logError("problem initializing tool options", (Throwable)e);
        }
    }

    private static enum IARPropGroup {
        toolchain("iar.arm.toolchain.v6.1.0"),
        compiler("iar.arm.toolchain.compiler.v5.4.1"),
        assembler("iar.arm.toolchain.assembler.v5.4.0"),
        linker("iar.arm.toolchain.linker.v5.4.0");

        public final String id;
        IPropertyGroup group;

        private IARPropGroup(String id) {
            this.id = id;
        }

        IPropertyGroup getProperty() {
            if (this.group == null) {
                IARDirectOptionsMapping.initToolchainSupport();
                this.group = tcSupport.getCdtToolOrToolChainPropertyGroup(this.id);
            }
            return this.group;
        }
    }
}

