/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic.model;

import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.utils.IGeneratorPathManager;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.INonTemplateContext;
import com.silabs.ss.framework.project.internal.core.type.vscodecmake.IGeneratorFactory;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.IToolsInfoService;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.ToolsInfoService;
import com.silabs.ss.support.mcu.api.part.core.MCUPartProperties;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class NonTemplateFileContext
implements INonTemplateContext {
    private static final String GENERATOR_FACTORY = "org.eclipse.embedcdt.debug.core.svdPath";
    private static IGeneratorPathManager svdPathManager;
    private static final IToolsInfoService toolsInfoService;
    private IProjectEntity externalProject;

    static {
        toolsInfoService = ToolsInfoService.instance();
    }

    public NonTemplateFileContext(IProjectEntity externalProject) {
        this.externalProject = externalProject;
    }

    public IProjectEntity getExternalProject() {
        return this.externalProject;
    }

    public String getPartId() {
        return (String)this.externalProject.getCurrentConfiguration().getProperty(ProjectProperties.PART_ID);
    }

    public String getProjectName() {
        return ((IProjectDescriptor)this.externalProject.getDescriptor()).getId();
    }

    public String getPartNumber() {
        return this.part().map(IDescribable::getName).orElse("");
    }

    public String getDebugPartName() {
        return this.part().map(p -> (String)p.getProperty(MCUPartProperties.DEBUG_PART_NAME)).orElse("");
    }

    private Optional<IPartDescriptor> part() {
        return Optional.ofNullable((IPartDescriptor)Part.manager().findDescriptor(this.getPartId()));
    }

    public IGeneratorPathManager getSvdPathManager() {
        IConfigurationElement[] configElementGenerator;
        if (svdPathManager == null && (configElementGenerator = Platform.getExtensionRegistry().getConfigurationElementsFor(GENERATOR_FACTORY)).length > 0) {
            try {
                IGeneratorFactory factory = (IGeneratorFactory)configElementGenerator[0].createExecutableExtension("class");
                svdPathManager = factory.createGeneratorPathManager();
            }
            catch (Exception e) {
                Activator.reporter.logException((Throwable)e);
            }
        }
        return svdPathManager;
    }

    public IToolsInfoService getToolsInfoService() {
        return toolsInfoService;
    }
}

