/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic.metadata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@JsonDeserialize(builder=Builder.class)
public final class IDEMetadata {
    private String ideId;
    private String ideName;
    private String ideDescription;
    private String ideCompatibility;
    private List<String> projectFileExtensions;
    private String idePath;
    private List<String> keywords;
    private int templatesVersion = -1;
    private List<IDETemplate> templates;
    private List<IDEGenerator> generators;
    private String launcherId;
    private List<IDETemplate> solutionTemplates;
    private List<IDEGenerator> solutionGenerators;

    private IDEMetadata(String ideName, String ideDescription, String ideCompatibility, List<String> projectFileExtensions, String idePath, List<String> keywords, int templatesVersion, List<IDETemplate> templates, List<IDEGenerator> generators, String launcherId, List<IDETemplate> solutionTemplates, List<IDEGenerator> solutionGenerators) {
        this.ideId = ideName != null ? ideName.trim().toLowerCase(Locale.ROOT).replace(" ", "-") : "";
        this.ideName = ideName != null ? ideName.trim() : "";
        this.ideDescription = ideDescription != null ? ideDescription.trim() : "";
        this.ideCompatibility = ideCompatibility != null ? ideCompatibility.trim() : "";
        this.projectFileExtensions = projectFileExtensions != null ? projectFileExtensions : new ArrayList();
        this.idePath = idePath != null ? idePath.toString() : "";
        this.keywords = keywords != null ? keywords : new ArrayList();
        this.templatesVersion = templatesVersion;
        this.templates = templates != null ? templates : new ArrayList();
        this.generators = generators != null ? generators : new ArrayList();
        this.launcherId = launcherId != null ? launcherId.trim() : "";
        this.solutionTemplates = solutionTemplates != null ? solutionTemplates : new ArrayList();
        this.solutionGenerators = solutionGenerators != null ? solutionGenerators : new ArrayList();
    }

    public String getId() {
        return this.ideId;
    }

    public String getIdeName() {
        return this.ideName;
    }

    public String getIdeDescription() {
        return this.ideDescription;
    }

    public String getIdeCompatibility() {
        return this.ideCompatibility;
    }

    public List<String> getProjectFileExtensions() {
        return this.projectFileExtensions;
    }

    public String getIdePath() {
        return this.idePath;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Integer getTemplatesVersion() {
        return this.templatesVersion;
    }

    public List<IDETemplate> getTemplates() {
        return this.templates;
    }

    public List<IDETemplate> getSolutionTemplates() {
        return this.solutionTemplates;
    }

    public List<IDEGenerator> getGenerators() {
        return this.generators;
    }

    public List<IDEGenerator> getSolutionGenerators() {
        return this.solutionGenerators;
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("IDEMetadata: ");
        strBuilder.append(this.ideName);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("IDEMetadata Description: ");
        strBuilder.append(this.ideDescription);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("IDE Compatibility: ");
        strBuilder.append(this.ideCompatibility);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Project File Extensions: ");
        strBuilder.append(String.join((CharSequence)",", this.projectFileExtensions));
        strBuilder.append(System.lineSeparator());
        strBuilder.append("IDEMetadata Path: ");
        strBuilder.append(this.idePath);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Keywords: ");
        strBuilder.append(String.join((CharSequence)",", this.keywords));
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Template Version: ");
        strBuilder.append(this.templatesVersion);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Templates: ");
        strBuilder.append(System.lineSeparator());
        this.templates.stream().forEach(strBuilder::append);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Generators: ");
        strBuilder.append(System.lineSeparator());
        this.generators.stream().forEach(strBuilder::append);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Launcher Id: ");
        strBuilder.append(this.launcherId);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Solution Templates: ");
        strBuilder.append(System.lineSeparator());
        this.solutionTemplates.stream().forEach(strBuilder::append);
        strBuilder.append(System.lineSeparator());
        strBuilder.append("Solution Generators: ");
        strBuilder.append(System.lineSeparator());
        this.solutionGenerators.stream().forEach(strBuilder::append);
        strBuilder.append(System.lineSeparator());
        return strBuilder.toString();
    }

    @JsonPOJOBuilder
    public static class Builder {
        String ideName;
        String ideDescription;
        String ideCompatibility;
        List<String> projectFileExtensions;
        String idePath;
        List<String> keywords;
        int templatesVersion = -1;
        List<IDETemplate> templates;
        List<IDEGenerator> generators;
        String launcherId;
        List<IDETemplate> solutionTemplates;
        List<IDEGenerator> solutionGenerators;

        public Builder withIdeName(String ideName) {
            this.ideName = ideName;
            return this;
        }

        public Builder withIdeDescription(String ideDescription) {
            this.ideDescription = ideDescription;
            return this;
        }

        public Builder withIdeCompatibility(String ideCompatibility) {
            this.ideCompatibility = ideCompatibility;
            return this;
        }

        public Builder withProjectFileExtensions(List<String> projectFileExtensions) {
            this.projectFileExtensions = projectFileExtensions;
            return this;
        }

        public Builder withIdePath(String idePath) {
            this.idePath = idePath;
            return this;
        }

        public Builder withKeywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder withTemplatesVersion(Integer version) {
            this.templatesVersion = version;
            return this;
        }

        public Builder withTemplates(List<IDETemplate> templates) {
            this.templates = templates;
            return this;
        }

        public Builder withSolutionTemplates(List<IDETemplate> solutionTemplates) {
            this.solutionTemplates = solutionTemplates;
            return this;
        }

        public Builder withGenerators(List<IDEGenerator> generators) {
            this.generators = generators;
            return this;
        }

        public Builder withSolutionGenerators(List<IDEGenerator> solutionGenerators) {
            this.solutionGenerators = solutionGenerators;
            return this;
        }

        public Builder withLauncherId(String launcherId) {
            this.launcherId = launcherId;
            return this;
        }

        public IDEMetadata build() {
            return new IDEMetadata(this.ideName, this.ideDescription, this.ideCompatibility, this.projectFileExtensions, this.idePath, this.keywords, this.templatesVersion, this.templates, this.generators, this.launcherId, this.solutionTemplates, this.solutionGenerators);
        }
    }
}

