/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGenerator;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGeneratorFactory;
import com.silabs.ss.framework.project.api.generator.template.TemplateManager;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericIDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.NonTemplateFileGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.INonTemplateContext;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class GenericTypeUtils {
    private static final String NON_TEMPALATE_FILE_GENERATOR = "com.silabs.ss.framework.project.core.nonTemplateFileGenerator";
    private static final Map<Path, Object> SYNC_MAP = new ConcurrentHashMap<Path, Object>();

    private GenericTypeUtils() {
    }

    public static <T> T synchronizeFile(File file, Supplier<T> handler) {
        Object[] results = new Object[1];
        SYNC_MAP.compute(file.toPath().normalize(), (k, v) -> {
            objectArray[0] = handler.get();
            return null;
        });
        return (T)results[0];
    }

    public static ITemplateGenerator createGenerator(List<File> templateFiles) throws CoreException {
        return TemplateManager.currentTemplateFactory().map(ITemplateGeneratorFactory::make).orElseThrow(() -> Activator.reporter.newCoreException("Failed to generate project file(s) using Templating engine! Files: " + templateFiles.stream().map(File::getName).collect(Collectors.joining(", "))));
    }

    public static void generateOutputFromTemplateFiles(IGenericIDETemplate templates, File template, ITemplateGenerator generator, File outputFile) {
        GenericTypeUtils.synchronizeFile(outputFile, () -> GenericTypeUtils.doGenerateFile(templates, template, generator, outputFile));
    }

    private static File doGenerateFile(IGenericIDETemplate templates, File template, ITemplateGenerator generator, File outputFile) {
        boolean isAlwaysRegenerated = templates.isAlwaysRegenerate(template);
        boolean isGenerated = templates.isGenerated(template);
        try {
            if (isAlwaysRegenerated && isGenerated) {
                GenericTypeUtils.generateOutput(generator, template, outputFile, true);
            } else if (isAlwaysRegenerated && !isGenerated) {
                FileUtils.copyFile((File)template, (File)outputFile);
            } else if (!isAlwaysRegenerated && isGenerated && !outputFile.exists()) {
                GenericTypeUtils.generateOutput(generator, template, outputFile, true);
            } else if (!(isAlwaysRegenerated || isGenerated || outputFile.exists())) {
                FileUtils.copyFile((File)template, (File)outputFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return outputFile;
    }

    public static File generateOutput(ITemplateGenerator generator, File templateFile, File outputFile, boolean overwrite) throws IOException {
        if (!overwrite && outputFile.isFile()) {
            return outputFile;
        }
        String content = generator.generateContent(templateFile.toPath());
        outputFile.getParentFile().mkdirs();
        FileUtils.writeFileContents((File)outputFile, (String)content);
        return outputFile;
    }

    public static void generateOutputWithGenerators(List<IDEGenerator> nonTemplateGeneratorList, INonTemplateContext context) throws CoreException {
        if (nonTemplateGeneratorList == null) {
            return;
        }
        for (IDEGenerator nonTemplateGenerator : nonTemplateGeneratorList) {
            boolean isOptional = nonTemplateGenerator.isOptional();
            IConfigurationElement[] configElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(NON_TEMPALATE_FILE_GENERATOR);
            IConfigurationElement myGeneratorElement = Stream.of(configElementArray).filter(element -> element.getAttribute("name").equalsIgnoreCase(nonTemplateGenerator.getGeneratorName())).findFirst().orElse(null);
            if (myGeneratorElement != null) {
                NonTemplateFileGenerator myGenerator = (NonTemplateFileGenerator)myGeneratorElement.createExecutableExtension("class");
                myGenerator.generate(context);
                continue;
            }
            if (!isOptional) {
                throw Activator.reporter.newCoreException("Missing reguired file generator: " + String.valueOf(nonTemplateGenerator));
            }
            Activator.reporter.logInfo("Cannot find file generator with name: " + String.valueOf(nonTemplateGenerator), (Throwable)ExceptionUtils.newMinimalStackException());
        }
    }
}

