/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.Result;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.ss.framework.project.internal.core.type.generic.BaseGenericTemplates;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericIDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadata;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplate;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class GenericTemplates
extends BaseGenericTemplates<IGenericIDETemplate> {
    public static final String VAR_PROJECT_NAME = "PROJECT_NAME";
    private String name;
    private int version = -1;
    private static String startupHash = String.valueOf(System.currentTimeMillis());
    private List<IGenericIDETemplate> templates;

    public GenericTemplates(IDEMetadata aIDE, List<IDETemplate> templatesToUse) {
        this.name = aIDE.getIdeName();
        this.version = aIDE.getTemplatesVersion();
        this.templates = new ArrayList<IGenericIDETemplate>();
        this.addTemplates(templatesToUse);
    }

    public static void updateStoredHash() {
        if (!RuntimeUtils.isJUnitRunning()) {
            throw new IllegalStateException("This is a test method and should not be called at runtime!");
        }
        startupHash = String.valueOf(System.currentTimeMillis());
    }

    protected void addTemplates(List<IDETemplate> templatesToUse) {
        for (IDETemplate templateSrc : templatesToUse) {
            GenericTemplate tmpl = new GenericTemplate(templateSrc, this);
            this.templates.add(tmpl);
        }
    }

    @Override
    protected Stream<IGenericIDETemplate> getDefaultTemplates(IDescriptor desc) {
        ArrayList<IGenericIDETemplate> defaultTmpls = new ArrayList<IGenericIDETemplate>();
        for (IGenericIDETemplate template : this.templates) {
            if (template.resolvedTemplates(desc).filter(Result::isOK).count() <= 0L) continue;
            defaultTmpls.add(template);
        }
        return defaultTmpls.stream();
    }

    @Override
    protected int templateVersion() {
        return this.version;
    }

    @Override
    protected String name() {
        return this.name;
    }

    @Override
    protected boolean isVersionValid(File versionFile) {
        if (!versionFile.isFile()) {
            return false;
        }
        try {
            return FileUtils.readFileContents((Path)versionFile.toPath(), (Charset)StandardCharsets.UTF_8).contains(startupHash);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    protected void writeVersionFile(File versionFile) throws IOException {
        FileUtils.writeFileContents((File)versionFile, (String)startupHash);
    }

    @Override
    protected String internalTemplateLocation() {
        return "data/";
    }

    @Override
    protected Stream<IGenericIDETemplate> existingCopiedTemplates() {
        return this.templates.stream();
    }

    @Override
    protected Stream<IGenericIDETemplate> loadCustom(IDescriptor desc, File templateDir) {
        return null;
    }

    public boolean isAlwaysRegenerate(File template) {
        boolean alwaysRegenerate = true;
        if (!this.templates.isEmpty()) {
            alwaysRegenerate = this.templates.get(0).isAlwaysRegenerate(template);
        }
        return alwaysRegenerate;
    }

    public boolean isStudioMetadataFile(File template) {
        boolean studioMetadataFile = false;
        if (!this.templates.isEmpty()) {
            studioMetadataFile = this.templates.get(0).isStudioMetadataFile(template);
        }
        return studioMetadataFile;
    }

    public boolean isGenerated(File template) {
        boolean generated = true;
        if (!this.templates.isEmpty()) {
            generated = this.templates.get(0).isGenerated(template);
        }
        return generated;
    }

    public Optional<String> getTargetPath(File template, IVariableLookup variables) {
        for (IGenericIDETemplate genTmpl : this.templates) {
            Optional<String> path = ((GenericTemplate)genTmpl).getTargetPath(template, variables);
            if (!path.isPresent()) continue;
            return path;
        }
        return Optional.empty();
    }

    public IVariableLookup createTargetPathLookup(IDescriptor projDesc) {
        return this.createTargetPathLookup(projDesc.getName());
    }

    public IVariableLookup createTargetPathLookup(String projectName) {
        return new MapVariableLookup(Map.of(VAR_PROJECT_NAME, projectName));
    }
}

