/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.Result;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTemplateFile;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTemplates;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericIDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplateFile;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplatePartCompatibility;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplateToolchain;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileArmGccGenericOptionMapper;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileArmIarGenericOptionMapper;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileHostGccGenericOptionMapper;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class GenericTemplate
implements IGenericIDETemplate {
    private static VariableSubstitutionEngine substEngine = new VariableSubstitutionEngine('{');
    private List<GenericTemplateFile> templateFiles = new ArrayList<GenericTemplateFile>();
    private String partCompatbility = "";
    private String toolchainId = "";
    private String basePropertyId = "";
    private IGenericOptionMappingRegistry registry;
    private GenericTemplates templates;

    static {
        substEngine.allowRecursion(true);
        substEngine.setOperatorHandler((IOperatorHandler)CoreOperatorHandler.INSTANCE);
    }

    public GenericTemplate(IDETemplate templateSrc, GenericTemplates templates) {
        this.init(templateSrc);
        this.templates = templates;
    }

    private void init(IDETemplate templateSrc) {
        this.initToolchainId(templateSrc);
        this.initPartCompat(templateSrc);
        this.initBasePropertyIdAndToolchainRegistry();
        this.initTemplateFiles(templateSrc);
    }

    private void initTemplateFiles(IDETemplate templateSrc) {
        for (IDETemplateFile tmplFile : templateSrc.getFiles()) {
            GenericTemplateFile template = new GenericTemplateFile(new File(tmplFile.getFile()), tmplFile.isGenerated(), tmplFile.isAlwaysRegenerate(), tmplFile.isStudioMetadataFile(), tmplFile.getTargetPath());
            this.templateFiles.add(template);
        }
    }

    private void initBasePropertyIdAndToolchainRegistry() {
        if (TextUtils.isEmpty((String)this.toolchainId) || TextUtils.isEmpty((String)this.partCompatbility) || this.isApplicable("makefile.arm.gcc")) {
            this.basePropertyId = "makefile.arm.gcc";
            this.registry = MakefileArmGccGenericOptionMapper.gccRegistry();
        } else if (this.isApplicable("makefile.host.gcc")) {
            this.basePropertyId = "makefile.host.gcc";
            this.registry = MakefileHostGccGenericOptionMapper.gccRegistry();
        } else if (this.isApplicable("makefile.arm.iar")) {
            this.basePropertyId = "makefile.arm.iar";
            this.registry = MakefileArmIarGenericOptionMapper.iarRegistry();
        }
    }

    private boolean isApplicable(String baseId) {
        return baseId.contains(this.toolchainId) && baseId.contains(this.partCompatbility);
    }

    private void initPartCompat(IDETemplate templateSrc) {
        Optional partCompat = templateSrc.getPartCompatibility().stream().findAny();
        if (partCompat.isPresent()) {
            this.partCompatbility = ((IDETemplatePartCompatibility)partCompat.get()).getId();
        }
    }

    private void initToolchainId(IDETemplate templateSrc) {
        Optional toolchainCompat = templateSrc.getToolchains().stream().findAny();
        if (toolchainCompat.isPresent()) {
            this.toolchainId = ((IDETemplateToolchain)toolchainCompat.get()).getId();
        }
    }

    @Override
    public Stream<Result<File, IOException>> resolvedTemplates(IDescriptor desc) {
        ArrayList<Result<File, IOException>> resolved = new ArrayList<Result<File, IOException>>();
        if (desc != null) {
            String coreCompat;
            String toolchainId;
            Collection tcCompat = (Collection)desc.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
            if (tcCompat.isEmpty() && !TextUtils.isBlank((String)(toolchainId = (String)desc.getProperty(ProjectCommonProperties.TOOLCHAIN_ID)))) {
                tcCompat.add(toolchainId);
            }
            if ((coreCompat = desc.getPropertyAccess().getValueString(ProjectProperties.ALLOWED_CORE_ARCHITECTURE)) != null && !tcCompat.isEmpty()) {
                boolean isMatch;
                boolean bl = isMatch = tcCompat.stream().anyMatch(tc -> tc.equalsIgnoreCase(this.toolchainId) || tc.contains(this.toolchainId)) && coreCompat.equalsIgnoreCase(this.partCompatbility);
                if (!isMatch) {
                    return resolved.stream();
                }
            }
            this.collectResolvedTemplateFiles(desc, resolved, this.templateFiles);
        }
        return resolved.stream();
    }

    private void collectResolvedTemplateFiles(IDescriptor desc, List<Result<File, IOException>> resolved, List<GenericTemplateFile> templatesToLoad) {
        for (GenericTemplateFile tmplFile : templatesToLoad) {
            if (tmplFile.getFile() == null || TextUtils.isBlank((String)tmplFile.getFile().toString())) continue;
            resolved.add(this.templates.loadTemplate(tmplFile.getFile().toString(), desc));
        }
    }

    @Override
    public Stream<String> internalTemplates() {
        return this.templateFiles.stream().map(GenericTemplateFile::getFile).map(File::toString);
    }

    @Override
    public IGenericOptionMappingRegistry genericRegistry() {
        return this.registry;
    }

    @Override
    public String basePropertyId() {
        return this.basePropertyId;
    }

    public boolean hasExternalTemplates() {
        return this.templateFiles.size() > 0;
    }

    @Override
    public boolean isAlwaysRegenerate(File template) {
        Boolean isRegen = this.findTemplateFile(template).map(GenericTemplateFile::isAlwaysRegenerated).orElse(true);
        return isRegen;
    }

    @Override
    public boolean isStudioMetadataFile(File template) {
        Boolean isMetaFile = this.findTemplateFile(template).map(GenericTemplateFile::isStudioMetadataFile).orElse(true);
        return isMetaFile;
    }

    @Override
    public boolean isGenerated(File template) {
        Boolean isGenerated = this.findTemplateFile(template).map(GenericTemplateFile::isGenerated).orElse(true);
        return isGenerated;
    }

    @Override
    public Optional<String> getTargetPath(File template, IVariableLookup variables) {
        Optional<String> tmplFile = this.findTemplateFile(template).map(t -> this.templateTargetPath((GenericTemplateFile)t, template)).map(p -> substEngine.substitute(p, variables)).map(path -> {
            if (path.equals("..") || path.startsWith("../") || path.endsWith("/..") || path.contains("/../")) {
                throw new IllegalArgumentException("targetPath cannot contain '..'");
            }
            return path;
        }).filter(p -> !p.isBlank());
        return tmplFile;
    }

    private String templateTargetPath(GenericTemplateFile tmplFile, File template) {
        String targetPath = Optional.ofNullable(tmplFile.getTargetPath()).orElse("${PROJECT_NAME}." + FileUtils.getExtension((File)template));
        return targetPath.trim();
    }

    private Optional<GenericTemplateFile> findTemplateFile(File aTemplate) {
        if (aTemplate == null) {
            return Optional.empty();
        }
        Optional<GenericTemplateFile> found = this.templateFiles.stream().filter(f -> aTemplate.getPath().endsWith(f.getFile().getPath())).findFirst();
        return found;
    }
}

