/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalSolutionModelHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GenericSolutionMetadataHandler
extends ExternalProjectMetadataHandler<MSolution, GenericSolutionMetadataHandler> {
    private static final String KEY_METADATA = "SIMPLICITY_STUDIO_METADATA";
    private static final String BEG_METADATA_LINE = "# SIMPLICITY_STUDIO_METADATA=";
    private static final String END_METADATA_LINE = "=END_SIMPLICITY_STUDIO_METADATA";
    private File projFile;
    private ExternalSolutionModelHandler modules;
    private Map<String, Object> contentMap;

    public ExternalSolutionModelHandler solution() {
        return this.modules;
    }

    private GenericSolutionMetadataHandler(Map<String, Object> contentMap, File projFile) {
        this.contentMap = contentMap;
        this.projFile = projFile;
    }

    public static GenericSolutionMetadataHandler forLoading(File slnMakefile) {
        return GenericSolutionMetadataHandler.forWriting(null, slnMakefile);
    }

    public static GenericSolutionMetadataHandler forWriting(Map<String, Object> contentMap, File projFile) {
        return (GenericSolutionMetadataHandler)new GenericSolutionMetadataHandler(contentMap, projFile).load();
    }

    @Override
    protected void loadMetadataHandlers(List<IExternalProjectMetadata<MSolution>> handlers) {
        this.modules = new ExternalSolutionModelHandler();
        handlers.add(this.modules);
    }

    @Override
    protected void writeStringContent(String metadata) {
        this.contentMap.put(KEY_METADATA, metadata);
    }

    @Override
    protected String getStringContent() {
        return this.extractMetadataFromFile(this.projFile);
    }

    protected String extractMetadataFromFile(File outputFile) {
        String content;
        if (!outputFile.exists()) {
            return "";
        }
        try {
            content = new String(FileUtils.readFileContents((File)outputFile, null));
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
            return "";
        }
        int begMetadata = content.lastIndexOf(BEG_METADATA_LINE);
        if (begMetadata < 0) {
            return "";
        }
        int endMetadata = content.lastIndexOf(END_METADATA_LINE);
        if (endMetadata < 0 || endMetadata < begMetadata) {
            return "";
        }
        String mapContent = content.substring(begMetadata + BEG_METADATA_LINE.length(), endMetadata);
        return mapContent;
    }
}

