/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericIDE;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEMetadata;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDETemplatePartCompatibility;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class GenericIDEFactory {
    private GenericIDEFactory() {
    }

    public static List<GenericIDE> create(List<IDEMetadata> idesFromMetadata) {
        return idesFromMetadata.stream().flatMap(GenericIDEFactory::create).collect(Collectors.toList());
    }

    private static Stream<GenericIDE> create(IDEMetadata aIDE) {
        if (aIDE == null) {
            return Stream.of(new GenericIDE[0]);
        }
        HashSet<String> partCompat = new HashSet<String>();
        for (IDETemplate tmpl : aIDE.getTemplates()) {
            for (IDETemplatePartCompatibility pc : tmpl.getPartCompatibility()) {
                String id = pc.getId().toLowerCase(Locale.ROOT);
                if ("ARM".equalsIgnoreCase(id)) {
                    partCompat.add("mcu.arm.*");
                    continue;
                }
                if ("8051".equalsIgnoreCase(id)) {
                    partCompat.add("mcu.8051.*");
                    continue;
                }
                if (!"HOST".equalsIgnoreCase(id)) continue;
                partCompat.add(".*host.*");
            }
        }
        IPath userHome = Path.fromOSString((String)HostUtils.userHome()).makeAbsolute();
        IPath ideExePath = userHome.uptoSegment(0);
        if (!TextUtils.isBlank((String)aIDE.getIdePath())) {
            ideExePath = Path.fromOSString((String)aIDE.getIdePath());
        }
        String ideVersion = null;
        return Stream.of(new GenericIDE(aIDE, aIDE.getIdeName(), aIDE.getIdeCompatibility(), ideVersion, aIDE.getIdeDescription(), ideExePath, String.join((CharSequence)" ", partCompat), aIDE.getProjectFileExtensions(), aIDE.getId(), aIDE.getLauncherId()));
    }
}

