/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.Result;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericTemplate;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.rcp.core.BundleUtils;
import com.silabs.ss.platform.api.rcp.core.DevUtils;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BaseGenericTemplates<Template extends IGenericTemplate> {
    private volatile boolean hasChecked = false;
    private static final Object CHECK_LOCK = new Object();
    private static final Map<File, Long> editStamp = new HashMap<File, Long>();

    public final ImmutableList<File> getTemplates(IExternalProjectEntity project, Template template) throws IOException {
        return this.getTemplates(true, template.resolvedTemplates((IDescriptor)project));
    }

    public final ImmutableList<File> getTemplates(ISolutionEntity solution, Template template) throws IOException {
        return this.getTemplates(true, template.resolvedTemplates((IDescriptor)solution));
    }

    public final Template getIDETemplate(IDescriptor desc) throws CoreException {
        return (Template)((IGenericTemplate)this.getDefaultTemplates(desc).findFirst().orElseThrow(() -> Activator.reporter.newCoreException("No compatible templates found for " + desc.getLabel())));
    }

    public Stream<File> getAllAllowedTemplates(IDescriptor desc) {
        ImmutableList<File> templates = this.getTemplates(desc, false, t -> t.resolvedTemplates(desc));
        return templates.stream();
    }

    public List<IGenericOptionMappingRegistry> getMappingRegistries(IDescriptor ... descs) {
        return Stream.of(descs).flatMap(this::getIDETemplates).distinct().map(IGenericTemplate::genericRegistry).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> getBasePropertyIds(IDescriptor desc) {
        return this.getIDETemplates(desc).map(IGenericTemplate::basePropertyId).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected abstract Stream<? extends Template> getDefaultTemplates(IDescriptor var1);

    protected abstract int templateVersion();

    protected abstract String name();

    protected abstract String internalTemplateLocation();

    protected abstract Stream<? extends IGenericTemplate> existingCopiedTemplates();

    protected abstract Stream<? extends Template> loadCustom(IDescriptor var1, File var2);

    protected String readmeFileName() {
        return "README.md";
    }

    protected boolean preferInternal() {
        return true;
    }

    @SafeVarargs
    protected final ImmutableList<File> getTemplates(IDescriptor desc, boolean throwErrors, Function<Template, Stream<Result<File, IOException>>> ... templTypes) throws UncheckedIOException {
        Stream<Result<File, IOException>> templateStream = this.getIDETemplates(desc).flatMap(t -> Stream.of(templTypes).flatMap(f -> (Stream)f.apply(t)));
        return this.getTemplates(throwErrors, templateStream);
    }

    private ImmutableList<File> getTemplates(boolean throwErrors, Stream<Result<File, IOException>> templateStream) {
        ArrayList failures = new ArrayList();
        ImmutableList.Builder templateFilesBuilder = ImmutableList.builder();
        templateStream.forEachOrdered(r -> r.either(arg_0 -> ((ImmutableList.Builder)templateFilesBuilder).add(arg_0), failures::add));
        if (failures.isEmpty()) {
            return templateFilesBuilder.build();
        }
        if (!throwErrors) {
            return ImmutableList.of();
        }
        throw new UncheckedIOException("Failed to load " + this.name() + " templates!\n" + failures.stream().map(Throwable::getMessage).collect(Collectors.joining("\\n  ")), (IOException)failures.get(0));
    }

    private final Stream<? extends Template> getIDETemplates(IDescriptor desc) {
        Stream<Template> customExportTemps = this.isCustom(desc);
        if (customExportTemps != null) {
            return customExportTemps;
        }
        return this.getDefaultTemplates(desc);
    }

    public Result<File, IOException> loadTemplate(String template, IDescriptor desc) {
        File templFile;
        File customDir = BaseGenericTemplates.getCustomDirectory(desc);
        if (customDir != null && (templFile = new File(customDir, template)).isFile()) {
            return Result.ok((Object)templFile);
        }
        IPath exporterDir = BaseGenericTemplates.getExporterDir();
        File copiedPath = exporterDir.append(template).toFile();
        Result<File, IOException> customFiles = this.customFiles(copiedPath, template);
        if (customFiles != null) {
            return customFiles;
        }
        File versionFile = this.checkForUpdates().orElse(null);
        if (versionFile != null) {
            try {
                versionFile.getParentFile().mkdirs();
                this.writeVersionFile(versionFile);
            }
            catch (IOException iOException) {}
        }
        if (TextUtils.hasContent((String)this.readmeFileName()) && !exporterDir.append(this.readmeFileName()).toFile().isFile()) {
            try {
                IPath templateFile = BundleUtils.getBundleContentPath((Bundle)Activator.getContext().getBundle(), (IPath)IPathUtils.createPath((String)this.internalTemplateLocation()).append(this.readmeFileName()), Collections.emptyMap());
                FileUtils.copyFile((File)templateFile.toFile(), (File)exporterDir.append(this.readmeFileName()).toFile());
            }
            catch (IOException iOException) {}
        }
        if (!this.preferInternal() && copiedPath.exists()) {
            return Result.ok((Object)copiedPath);
        }
        try {
            File internalTemplate = this.loadInternalLocation(template);
            if (internalTemplate != null && internalTemplate.exists()) {
                return Result.ok((Object)internalTemplate);
            }
        }
        catch (IOException iOException) {}
        return Result.ok((Object)copiedPath);
    }

    private File loadInternalLocation(String template) throws IOException {
        Bundle bundle = Optional.ofNullable(Activator.getContext()).map(BundleContext::getBundle).orElse(null);
        if (bundle == null) {
            return null;
        }
        return BundleUtils.getBundleContentPath((Bundle)bundle, (IPath)IPathUtils.createPath((String)this.internalTemplateLocation()).append(template), Collections.emptyMap()).toFile();
    }

    protected Result<File, IOException> customFiles(File copiedPath, String template) {
        return null;
    }

    protected final Stream<? extends Template> isCustom(IDescriptor desc) {
        File templateDir = BaseGenericTemplates.getCustomDirectory(desc);
        if (templateDir == null) {
            return null;
        }
        return this.loadCustom(desc, templateDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<File> checkForUpdates() {
        if (!RuntimeUtils.isJUnitRunning() && this.hasChecked) {
            return Optional.empty();
        }
        Object object = CHECK_LOCK;
        synchronized (object) {
            if (!RuntimeUtils.isJUnitRunning() && this.hasChecked) {
                return Optional.empty();
            }
            this.hasChecked = true;
            Path exportDir = BaseGenericTemplates.getExporterDir().toFile().toPath();
            File versionFile = exportDir.resolve(this.versionName()).toFile();
            if (this.isVersionValid(versionFile)) {
                return Optional.of(versionFile);
            }
            List templatePaths = this.existingCopiedTemplates().flatMap(IGenericTemplate::internalTemplates).collect(Collectors.toList());
            for (String templatePath : templatePaths) {
                File copyTo = exportDir.resolve(templatePath).toFile();
                long lastModified = copyTo.lastModified();
                if (copyTo.isFile() && Objects.equals(lastModified, editStamp.get(copyTo))) continue;
                try {
                    String copyToContents;
                    String tmplContents;
                    copyTo.getParentFile().mkdirs();
                    Path templateFile = this.loadInternalLocation(templatePath).toPath();
                    if (copyTo.isFile() && Objects.equals(tmplContents = FileUtils.readFileContents((Path)templateFile, (Charset)Charsets.UTF_8), copyToContents = FileUtils.readFileContents((Path)copyTo.toPath(), (Charset)Charsets.UTF_8))) continue;
                    FileUtils.copyFile((File)templateFile.toFile(), (File)copyTo);
                    lastModified = copyTo.lastModified();
                    editStamp.put(copyTo, lastModified);
                }
                catch (IOException e) {
                    if (Files.isRegularFile(copyTo.toPath(), new LinkOption[0])) continue;
                    Activator.reporter.logWarning("Failed to copy " + templatePath, (Throwable)e);
                }
            }
            return Optional.of(versionFile);
        }
    }

    protected boolean isVersionValid(File versionFile) {
        return versionFile.isFile();
    }

    protected void writeVersionFile(File versionFile) throws IOException {
        FileUtils.writeFileContents((File)versionFile, (String)"");
    }

    private String versionName() {
        return ".version." + this.name().replaceAll("\\W+", "_") + this.templateVersion();
    }

    protected static final IPath getExporterDir() {
        IPath basePath = DevUtils.getInstallPath().append("developer");
        if (RuntimeUtils.isPlatformPDELaunch() || RuntimeUtils.isJUnitRunning()) {
            basePath = DevUtils.getWorkspaceLocation();
        }
        return basePath.append("exporter_templates/");
    }

    private static File getCustomDirectory(IDescriptor desc) {
        File templateDir;
        URI customDir = (URI)desc.getProperty(ToolchainProperties.CUSTOM_EXPORT_TEMPLATE_DIR);
        if (customDir == null) {
            return null;
        }
        try {
            templateDir = URIUtils.toFileWithRelative((URI)customDir);
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to load the template directory for " + String.valueOf(customDir), (Throwable)e);
            return null;
        }
        if (!templateDir.isDirectory()) {
            return null;
        }
        return templateDir;
    }

    protected static class CustomExportTemplates
    implements IGenericTemplate {
        private final List<Result<File, IOException>> contentTemplates;

        public CustomExportTemplates(Collection<File> projectTempls) {
            this.contentTemplates = projectTempls.stream().map(Result::ok).collect(Collectors.toList());
        }

        @Override
        public Stream<Result<File, IOException>> resolvedTemplates(IDescriptor desc) {
            return this.contentTemplates.stream();
        }

        @Override
        public Stream<String> internalTemplates() {
            return Stream.empty();
        }

        @Override
        public IGenericOptionMappingRegistry genericRegistry() {
            return null;
        }

        @Override
        public String basePropertyId() {
            return null;
        }
    }
}

