/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class ExternalProjectPathVariablesController
implements IExternalProjectMetadata<MProject> {
    private static final String KEY_PATH_VARIABLES = "SIMPLICITY_STUDIO_PATH_VARIABLES";
    private Map<String, String> variablePaths = new HashMap<String, String>();

    public void addSdkPath(String sdkUri) {
        this.variablePaths.put("sdk", sdkUri);
    }

    public void addToolchainPath(String toolchainUri) {
        this.variablePaths.put("toolchain", toolchainUri);
    }

    @Override
    public void apply(final MProject project) {
        new ProjectModelSwitchRecurser<Object>(){

            public Object caseMIncludePath(MIncludePath path) {
                String uriStr = path.getUri();
                try {
                    URI baseUri = URI.create(uriStr);
                    String newUri = ProjectModelUtils.replaceUriWithStudioVariable(baseUri.toString(), project.getContentRoot(), "project");
                    newUri = ProjectModelUtils.replaceUriWithStudioVariable(newUri, ExternalProjectPathVariablesController.this.variablePaths.get("sdk"), "sdk");
                    newUri = ProjectModelUtils.replaceUriWithStudioVariable(newUri, ExternalProjectPathVariablesController.this.variablePaths.get("toolchain"), "toolchain");
                    path.setUri(newUri);
                }
                catch (Exception exception) {}
                return null;
            }
        }.doSwitch((EObject)project);
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String copiedFileRefs = CoreTypes.STRING_TO_STRING_MAP.stringize(this.variablePaths);
        handler.put(KEY_PATH_VARIABLES, copiedFileRefs);
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String variablesStr = handler.get(KEY_PATH_VARIABLES);
        this.variablePaths = new HashMap<String, String>((Map)CoreTypes.STRING_TO_STRING_MAP.convert(variablesStr));
    }
}

