/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.IProjectFileContentVisitor;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IConfigurationScopeEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEntryEngineOperation;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.internal.core.engine.ProjectEngineOperationHolder;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelCompatibility;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngine;
import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class ProjectModelEngineProjectVisitor
implements IProjectFileContentVisitor {
    private final IProjectDescriptor projectDescriptor;
    private final IProjectEngineOperationFactory factory;
    private final IProjectEngineSession session;
    private final ProjectEngineOperationHolder operations;
    private final Deque<Boolean> excluding;
    private final ProjectModelCompatibility compat;

    public ProjectModelEngineProjectVisitor(IProjectDescriptor projectDescriptor, IProjectEngineOperationFactory factory, IProjectEngineSession session, ProjectEngineOperationHolder operations, Deque<Boolean> excluding, ProjectModelCompatibility compat) {
        this.projectDescriptor = projectDescriptor;
        this.factory = factory;
        this.session = session;
        this.operations = operations;
        this.excluding = excluding;
        this.compat = compat;
    }

    @Override
    public void visitFailed(MFolderEntry container, File containerFile, IPath projectPath, MEntry entry, MSelectable selectable, File entryFile, IOException e) {
        if (entry instanceof MFileEntry && this.session.getProjectDescriptor() instanceof IImportProjectDescriptor) {
            this.visit(container, containerFile, projectPath, (MFileEntry)entry, selectable, entryFile);
        } else {
            this.operations.add(this.factory.createReportErrorOperation(this.session, entry, entryFile, e));
        }
    }

    @Override
    public boolean preVisit(MFolderEntry container, File containerFile, IPath projectPath, MSelectable selector, File contentFolder) {
        IAddToProjectEngineOperation op;
        List<IBuildConfigurationDescriptor> exclCfgs;
        block9: {
            exclCfgs = this.compat.calculateContentExclusion(this.projectDescriptor, selector);
            if (exclCfgs == null) {
                return false;
            }
            try {
                op = this.factory.createAddProjectFolderOperation(this.session, containerFile, projectPath, contentFolder, container, selector);
                if (op != null) break block9;
                this.excluding.push(false);
                return true;
            }
            catch (IOException e) {
                this.operations.add(this.factory.createReportErrorOperation(this.session, (MEntry)container, contentFolder, e));
                return false;
            }
        }
        boolean isIncluded = ProjectModelEngine.shouldIncludeEntry(this.excluding, (MEntry)container, containerFile, contentFolder);
        if (isIncluded) {
            this.operations.add(op);
        }
        this.applyConfigFilters(op, exclCfgs);
        if (isIncluded) {
            if (!(container instanceof MFolderContent && ((MFolderContent)container).isVirtual() || this.factory.shouldEnter(this.session, container, op))) {
                this.excluding.push(true);
            } else {
                this.excluding.push(false);
            }
        } else {
            this.excluding.push(true);
        }
        return true;
    }

    @Override
    public void visit(MFolderEntry container, File containerFile, IPath projectPath, MFileEntry entry, MSelectable selector, File contentFile) {
        List<IBuildConfigurationDescriptor> exclCfgs = this.compat.calculateContentExclusion(this.projectDescriptor, selector);
        if (exclCfgs == null) {
            return;
        }
        try {
            IAddToProjectEngineOperation op = this.factory.createAddProjectFileOperation(this.session, containerFile, projectPath, contentFile, entry, selector);
            if (op == null) {
                return;
            }
            if (ProjectModelEngine.shouldIncludeEntry(this.excluding, (MEntry)entry, containerFile, contentFile)) {
                this.operations.add(op);
            }
            this.applyConfigFilters(op, exclCfgs);
        }
        catch (IOException e) {
            this.operations.add(this.factory.createReportErrorOperation(this.session, (MEntry)entry, contentFile, e));
        }
    }

    @Override
    public boolean postVisit(MFolderEntry entry, IPath projectPath, File contentFolder) {
        this.excluding.pop();
        return true;
    }

    protected void applyConfigFilters(IProjectEntryEngineOperation op, List<IBuildConfigurationDescriptor> exclCfgs) {
        if (exclCfgs == null || exclCfgs.isEmpty()) {
            return;
        }
        for (IBuildConfigurationDescriptor excl : exclCfgs) {
            IConfigurationScopeEngineOperation confOp = this.factory.createExcludeResourceFromConfigurationOperation(op.getSession(), excl.getId(), op.getProjectPath(), null);
            this.operations.add(confOp);
        }
    }
}

