/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.MProjectCanonicalizer;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.IProjectFileContentVisitor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngine;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectResourceFilterOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseProjectEngineConfigOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IConfigurationScopeEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.model.IResourceFilterInfo;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.utils.ProjectModelObjFactory;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectEngineOperationHolder;
import com.silabs.ss.framework.project.internal.core.engine.ProjectEngineSession;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelCompatibility;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngineConfigVisitor;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngineProjectVisitor;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelModuleHandler;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelOptionEngine;
import com.silabs.ss.platform.performance.recording.LoggingFeature;
import com.silabs.ss.platform.performance.recording.PerformanceMetadata;
import com.silabs.ss.platform.performance.recording.StopWatch;
import com.silabs.ss.platform.performance.recording.rcp.PerformanceManager;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProjectModelEngine
implements IProjectModelEngine {
    private IProjectModel readOnlyUserModel;
    private IProjectModel readOnlyRawModel;
    private ProjectModelCompatibility compat;
    private IProjectModel resolvedModel;
    private ProjectModelModuleHandler moduleHandler;
    private MultiStatus status;

    public ProjectModelEngine(IProjectModel model) {
        this(model.getRawModel(), model);
    }

    public ProjectModelEngine(IProjectModel rawModel, IProjectModel userModel) {
        if (userModel == null) {
            throw new IllegalArgumentException();
        }
        this.readOnlyRawModel = rawModel;
        this.readOnlyUserModel = userModel;
        this.compat = new ProjectModelCompatibility(userModel);
        this.status = new MultiStatus(Activator.id(), 0, "Problems updating project!", null);
    }

    @Override
    public MultiStatus status() {
        return this.status;
    }

    protected IProjectModel expandModulesIntoModel(IProjectDescriptor projDesc) throws CoreException {
        if (this.resolvedModel == null) {
            StopWatch expandModulesTimer = PerformanceManager.INSTANCE.logStartChild(LoggingFeature.ALL, "Project Model Engine expanding modules into project");
            this.resolvedModel = this.doExpandModules(projDesc);
            expandModulesTimer.done();
            ProjectModelOptionEngine.resolveToolOptions(projDesc, this.resolvedModel.getModel());
        }
        return this.resolvedModel;
    }

    private IProjectModel doExpandModules(IProjectDescriptor projDesc) throws CoreException {
        this.validateModel(this.readOnlyUserModel);
        this.moduleHandler = new ProjectModelModuleHandler(this.readOnlyUserModel, this.readOnlyRawModel, projDesc);
        this.moduleHandler.apply();
        IProjectModel resolvedModel = IProjectModelEngineFactory.INSTANCE.createExistingProjectModel(this.moduleHandler.getExpandedModel(), this.readOnlyUserModel.getVariableLookup(), this.readOnlyUserModel.getContentRootURI(), this.moduleHandler.getProjectResourceTree());
        return resolvedModel;
    }

    protected void validateModel(IProjectModel model) throws CoreException {
        if (model == null) {
            return;
        }
        HashMap<String, MModule> projectModuleSet = new HashMap<String, MModule>();
        for (MModule module : model.getModel().getModules()) {
            MModule oldMod = projectModuleSet.put(module.getId(), module);
            if (oldMod == null || oldMod.isPdm() == module.isPdm()) continue;
            throw Activator.reporter.newCoreException(MessageFormat.format("Detected duplicate modules on a configuration: {0}", module.getId()));
        }
        HashMap<String, MModule> configModuleSet = new HashMap<String, MModule>();
        for (MConfiguration config : model.getModel().getConfigurations()) {
            configModuleSet.putAll(projectModuleSet);
            for (MModule module : config.getModules()) {
                MModule oldMod = projectModuleSet.put(module.getId(), module);
                if (oldMod == null || oldMod.isPdm() == module.isPdm()) continue;
                throw Activator.reporter.newCoreException(MessageFormat.format("Detected duplicate modules on a configuration: {0}", module.getId()));
            }
            configModuleSet.clear();
        }
    }

    @Override
    public MultiStatus validate(IProjectDescriptor projDesc) throws CoreException {
        final MultiStatus status = new MultiStatus(Activator.id(), 0, "Validation Results", null);
        IProjectEngineSession session = this.createExpandedModulesSession(projDesc);
        session.getProjectModel().accept(new IProjectFileContentVisitor(){

            @Override
            public void visitFailed(MFolderEntry container, File containerFile, IPath projectPath, MEntry entry, MSelectable selectable, File entryFile, IOException e) {
                if (entry instanceof MFileContent) {
                    status.add(Activator.reporter.newErrorStatus("Missing file referenced: " + entry.getName(), (Throwable)e));
                } else {
                    status.add(Activator.reporter.newErrorStatus("Missing directory referenced: " + entry.getName(), (Throwable)e));
                }
            }

            @Override
            public void visit(MFolderEntry container, File containerFile, IPath projectPath, MFileEntry entry, MSelectable selector, File contentFile) {
            }

            @Override
            public boolean preVisit(MFolderEntry content, File containerFile, IPath contentURI, MSelectable selector, File contentFolder) {
                return true;
            }

            @Override
            public boolean postVisit(MFolderEntry content, IPath contentURI, File contentFolder) {
                return true;
            }
        });
        return status;
    }

    protected IProjectEngineSession createExpandedModulesSession(IProjectDescriptor projectDesc) throws CoreException {
        ProjectEngineSession session = new ProjectEngineSession(this, this.expandModulesIntoModel(projectDesc), projectDesc);
        return session;
    }

    @Override
    public List<IProjectEngineOperation> createProjectEngineOperations(IProjectDescriptor projectDesc, IProjectEngineOperationFactory factory) throws CoreException {
        StopWatch projectOpTimer = PerformanceManager.INSTANCE.logStartChild(LoggingFeature.ALL, "Project Model Engine creating project operations");
        ProjectEngineOperationHolder operations = this.doCreateProjectEngineOperationsForProject(projectDesc, factory);
        IProjectEngineSession session = this.createExpandedModulesSession(projectDesc);
        IBuildConfigurationDescriptor[] iBuildConfigurationDescriptorArray = projectDesc.getBuildConfigurationDescriptors();
        int n = iBuildConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigurationDescriptor conf = iBuildConfigurationDescriptorArray[n2];
            this.createBuildConfigOperations(conf, operations, factory, session);
            ++n2;
        }
        this.addProjectDefinedModules(session, factory, operations);
        this.addModuleErrors(session, factory, this.moduleHandler.getStatus(), operations);
        projectOpTimer.done();
        return operations.toOperations();
    }

    @Override
    public List<IProjectEngineOperation> createProjectEngineOperationsForProject(IProjectDescriptor projectDesc, IProjectEngineOperationFactory factory) throws CoreException {
        return this.doCreateProjectEngineOperationsForProject(projectDesc, factory).toOperations();
    }

    private ProjectEngineOperationHolder doCreateProjectEngineOperationsForProject(IProjectDescriptor projectDesc, IProjectEngineOperationFactory factory) throws CoreException {
        IProjectEngineSession session = this.createExpandedModulesSession(projectDesc);
        ProjectEngineOperationHolder operations = new ProjectEngineOperationHolder();
        new MProjectCanonicalizer(session.getProjectModel(), projectDesc, true).doSwitch((EObject)session.getProjectModel().getModel());
        this.createFileFolderOperations(projectDesc, operations, factory, session);
        for (Map.Entry ent : session.getProjectModel().getModel().getFilterInfoMap().entrySet()) {
            for (IResourceFilterInfo info : (List)ent.getValue()) {
                operations.add(new AddProjectResourceFilterOperation(session, (IPath)ent.getKey(), info));
            }
        }
        operations.add(factory.createResetModuleReferencesOperation(session, ""));
        Collection<IModuleReference> visitedModules = this.moduleHandler.getVisitedModules(projectDesc);
        for (IModuleReference modRef : visitedModules) {
            IConfigurationScopeEngineOperation moduleReferenceOperation = factory.createAddModuleReferenceOperation(session, "", modRef);
            operations.add(moduleReferenceOperation);
        }
        this.addProjectDefinedModules(session, factory, operations);
        this.addModuleErrors(session, factory, this.moduleHandler.getStatus(), operations);
        return operations;
    }

    @Override
    public List<IProjectEngineOperation> createProjectEngineOperationsForConfig(IBuildConfigurationDescriptor buildConf, IProjectEngineOperationFactory factory) throws CoreException {
        StopWatch configOpTimer = PerformanceManager.INSTANCE.logStartChild(LoggingFeature.ALL, "Project Model Engine creating configuration operations");
        ProjectEngineOperationHolder operations = new ProjectEngineOperationHolder();
        IProjectEngineSession session = this.createExpandedModulesSession((IProjectDescriptor)buildConf.getParent());
        this.createConfigOperations(buildConf, operations, factory, session);
        this.createRemovalOperations(operations, factory, session);
        this.addProjectDefinedModules(session, factory, operations);
        this.addModuleErrors(session, factory, this.moduleHandler.getStatus(), operations);
        configOpTimer.done();
        return operations.toOperations();
    }

    private void createRemovalOperations(ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session) {
        this.moduleHandler.getRemovedFiles().stream().map(path -> factory.createRemoveProjectFileOperation(session, (IPath)path)).filter(Objects::nonNull).forEachOrdered(operations::add);
        this.moduleHandler.getRemovedFolders().stream().map(path -> factory.createRemoveProjectFolderOperation(session, (IPath)path)).filter(Objects::nonNull).forEachOrdered(operations::add);
    }

    private void createConfigOperations(IBuildConfigurationDescriptor buildConf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session) {
        MConfiguration config = session.getProjectModel().getModel().findConfigurationByName(buildConf.getName());
        if (config != null) {
            new MProjectCanonicalizer(session.getProjectModel(), buildConf, true).doSwitch((EObject)config);
        }
        this.createFileFolderOperations(buildConf, operations, factory, session);
        this.createBuildConfigOperations(buildConf, operations, factory, session);
    }

    private void addProjectDefinedModules(IProjectEngineSession session, IProjectEngineOperationFactory factory, ProjectEngineOperationHolder operations) {
        session.getProjectModel().getModel().getProjectDefinedModules().stream().map(MProject::copy).peek(arg_0 -> ((MProjectCanonicalizer)new MProjectCanonicalizer(session.getProjectModel(), session.getProjectDescriptor(), false, true, true)).doSwitch(arg_0)).map(m -> factory.createAddProjectDefinedModuleOperation(session, (MProject)m)).forEachOrdered(operations::add);
    }

    private void addModuleErrors(IProjectEngineSession session, IProjectEngineOperationFactory factory, MultiStatus multiStatus, ProjectEngineOperationHolder operations) {
        IStatus[] iStatusArray = multiStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectEngineOperation error;
            IStatus status = iStatusArray[n2];
            if (status.getSeverity() == 4 && (error = factory.createReportErrorOperation(session, (MEntry)this.resolvedModel.getModel(), null, new IOException(status.getMessage(), status.getException()))) != null) {
                operations.add(error);
            }
            ++n2;
        }
    }

    protected void createFileFolderOperations(IProjectDescriptor projectDescriptor, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session) {
        ArrayDeque<Boolean> excluding = new ArrayDeque<Boolean>();
        session.getProjectModel().accept(new ProjectModelEngineProjectVisitor(projectDescriptor, factory, session, operations, excluding, this.compat));
    }

    protected void createFileFolderOperations(IBuildConfigurationDescriptor buildConf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session) {
        ArrayDeque<Boolean> excluding = new ArrayDeque<Boolean>();
        session.getProjectModel().accept(new ProjectModelEngineConfigVisitor(buildConf, factory, session, operations, excluding, this.compat));
    }

    protected static boolean shouldIncludeEntry(Deque<Boolean> excluding, MEntry entry, File containerFile, File contentFile) {
        boolean folderExcluded;
        boolean bl = folderExcluded = excluding.isEmpty() || excluding.peek() == false;
        if (folderExcluded) {
            return true;
        }
        if (!(entry instanceof MContent)) {
            return false;
        }
        MContent content = (MContent)entry;
        if (content.isLinked()) {
            return true;
        }
        if (contentFile != null && containerFile != null && !contentFile.toPath().startsWith(containerFile.toPath())) {
            return true;
        }
        return contentFile != null && !contentFile.exists();
    }

    protected void createBuildConfigOperations(IBuildConfigurationDescriptor conf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session) {
        MProject mproject = session.getProjectModel().getModel();
        this.createSettingSiteOperations(conf, operations, factory, session, (MSettingsSite)mproject, null);
        MConfiguration match = mproject.findConfigurationByName(conf.getName());
        if (match != null) {
            MConfiguration config = match;
            this.createConfigSettingsOperations(conf, operations, factory, session, (MConfigSettings)mproject);
            this.createConfigSettingsOperations(conf, operations, factory, session, (MConfigSettings)config);
            this.createRecursiveSettingSiteOperations(conf, operations, factory, session, config, (MEntry)mproject);
        }
        if (match == null && TextUtils.isEmpty((String)((String)conf.getProperty(BuildConfigProperties.CLONE_CONFIG_ID)))) {
            this.createConfigSettingsOperations(conf, operations, factory, session, (MConfigSettings)mproject);
            Object srcs = mproject.getSourceFolders();
            if (srcs.isEmpty()) {
                srcs = new LinkedHashSet(1);
                for (MConfiguration config : mproject.getConfigurations()) {
                    srcs.addAll(config.getSourceFolders());
                }
            }
            Iterator iterator = srcs.iterator();
            while (iterator.hasNext()) {
                String src = (String)iterator.next();
                operations.add(factory.createAddSourceFolderOperation(session, conf.getId(), Path.fromPortableString((String)src)));
            }
        }
        this.removeOldExclusions(conf, operations, factory, session);
    }

    protected void createConfigSettingsOperations(IBuildConfigurationDescriptor conf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session, MConfigSettings settings) {
        operations.add(factory.createResetModuleReferencesOperation(session, conf.getId()));
        for (IModuleReference modRef : this.moduleHandler.getVisitedModules(conf)) {
            IConfigurationScopeEngineOperation moduleReferenceOperation = factory.createAddModuleReferenceOperation(session, conf.getId(), modRef);
            operations.add(moduleReferenceOperation);
        }
        if (!TextUtils.isEmpty((String)settings.getOutputFileBase())) {
            operations.add(factory.createSetConfigurationOutputBaseNameOperation(session, conf.getId(), settings.getOutputFileBase()));
        }
        if (!TextUtils.isEmpty((String)settings.getPrebuildStep())) {
            operations.add(factory.createSetConfigurationPrebuildStepOperation(session, conf.getId(), settings.getPrebuildStep()));
        }
        if (!TextUtils.isEmpty((String)settings.getPostbuildStep())) {
            operations.add(factory.createSetConfigurationPostbuildStepOperation(session, conf.getId(), settings.getPostbuildStep()));
        }
        for (String sourceFolder : settings.getSourceFolders()) {
            operations.add(factory.createAddSourceFolderOperation(session, conf.getId(), (IPath)new Path(sourceFolder)));
        }
        for (String exclPath : settings.getExcludedPaths()) {
            operations.add(factory.createExcludeResourceFromConfigurationOperation(session, conf.getId(), (IPath)new Path(exclPath), null));
        }
    }

    private void removeOldExclusions(IBuildConfigurationDescriptor conf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session) {
        Collection modRefs = (Collection)conf.getProperty(ProjectCommonProperties.REFERENCED_MODULES);
        if (modRefs == null) {
            return;
        }
        Collection incResourcePaths = modRefs.stream().map(IModuleReference::getBuiltinExcludes).flatMap(Collection::stream).collect(Collectors.toSet());
        this.clearExcludedPathsFromInclusionList(incResourcePaths, conf, operations);
        for (String incPaths : incResourcePaths) {
            operations.add(factory.createIncludeResourceIntoConfigurationOperation(session, conf.getId(), (IPath)new Path(incPaths), null));
        }
    }

    private void clearExcludedPathsFromInclusionList(Collection<String> excludedPaths, IBuildConfigurationDescriptor conf, ProjectEngineOperationHolder operations) {
        operations.stream().map(arg_0 -> ((Caster)Caster.with(ExcludeResourceFromConfigurationOperation.class)).cast(arg_0)).filter(Objects::nonNull).filter(o -> Objects.equals(o.getBuildConfiguration(), conf.getId())).map(BaseProjectEngineConfigOperation::getProjectPath).map(IPath::toString).forEachOrdered(excludedPaths::remove);
    }

    protected void createSettingSiteOperations(IBuildConfigurationDescriptor conf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session, MSettingsSite settings, IPath projectPath) {
        Map<String, MToolOption> listOpts = this.formatMToolOptions(conf, settings);
        for (MToolOption option : listOpts.values()) {
            operations.add(factory.createAddToolOptionOperation(session, conf.getId(), option, (List<MToolListOption>)option.getToolListOptions(), projectPath));
        }
        for (MIncludePath include : settings.getIncludePaths()) {
            if (!this.compat.isCompatibleForConfig((MSelectable)include, conf)) continue;
            operations.add(factory.createAddIncludePathSettingOperation(session, conf.getId(), include, projectPath));
        }
        for (MMacroDefinition macro : settings.getMacroDefinitions()) {
            if (!this.compat.isCompatibleForConfig((MSelectable)macro, conf)) continue;
            operations.add(factory.createAddMacroDefinitionSettingOperation(session, conf.getId(), macro, projectPath));
        }
        for (MLibraryFile libfile : settings.getLibraryFiles()) {
            if (!this.compat.isCompatibleForConfig((MSelectable)libfile, conf)) continue;
            operations.add(factory.createAddLibraryFileOperation(session, conf.getId(), libfile));
        }
        for (MLibraryPath libpath : settings.getLibraryPaths()) {
            if (!this.compat.isCompatibleForConfig((MSelectable)libpath, conf)) continue;
            operations.add(factory.createAddLibraryPathOperation(session, conf.getId(), libpath));
        }
    }

    private Map<String, MToolOption> formatMToolOptions(IBuildConfigurationDescriptor conf, MSettingsSite settings) {
        LinkedHashMap<String, MToolOption> listOpts = new LinkedHashMap<String, MToolOption>();
        for (MToolOption toolOpt : settings.getToolOptions()) {
            if (!this.compat.isCompatibleForConfig((MSelectable)toolOpt, conf)) continue;
            MToolOption mainOption = (MToolOption)EcoreUtil.copy((EObject)toolOpt);
            if (!toolOpt.getToolListOptions().isEmpty()) {
                ProjectModelObjFactory.forMToolOption(toolOpt).convertToListOptions();
            }
            mainOption.getToolListOptions().clear();
            for (MToolListOption listOpt : toolOpt.getToolListOptions()) {
                if (!this.compat.isCompatibleForConfig((MSelectable)listOpt, conf)) continue;
                mainOption.getToolListOptions().add((Object)((MToolListOption)EcoreUtil.copy((EObject)listOpt)));
            }
            String toolKey = toolOpt.getToolId() + ":" + toolOpt.getOptionId();
            MToolOption oldOption = listOpts.put(toolKey, mainOption);
            if (oldOption == null) continue;
            if (!oldOption.getToolListOptions().isEmpty() || !mainOption.getToolListOptions().isEmpty()) {
                ProjectModelObjFactory.forMToolOption(oldOption).convertToListOptions();
                ProjectModelObjFactory.forMToolOption(mainOption).convertToListOptions();
            }
            if (mainOption.isBuiltin() && !oldOption.isBuiltin()) {
                listOpts.put(toolKey, oldOption);
                oldOption.getToolListOptions().addAll((Collection)mainOption.getToolListOptions());
                continue;
            }
            mainOption.getToolListOptions().addAll((Collection)oldOption.getToolListOptions());
        }
        return listOpts;
    }

    protected void createRecursiveSettingSiteOperations(IBuildConfigurationDescriptor conf, ProjectEngineOperationHolder operations, IProjectEngineOperationFactory factory, IProjectEngineSession session, MConfiguration config, MEntry entry) {
        IPath entryPath = ProjectModelUtils.getProjectPathFor(entry);
        this.createSettingSiteOperations(conf, operations, factory, session, (MSettingsSite)(entry instanceof MProject ? config : entry), entryPath);
        MSettingsSite entrySettings = (MSettingsSite)config.getEntrySettings().get((Object)entry);
        if (entrySettings != null) {
            this.createSettingSiteOperations(conf, operations, factory, session, entrySettings, entryPath);
        }
        if (entry instanceof MFolderEntry) {
            for (MFolderEntry folder : ((MFolderEntry)entry).getFolders()) {
                this.createRecursiveSettingSiteOperations(conf, operations, factory, session, config, (MEntry)folder);
            }
            for (MFileEntry file : ((MFolderEntry)entry).getFiles()) {
                this.createRecursiveSettingSiteOperations(conf, operations, factory, session, config, (MEntry)file);
            }
        }
    }

    @Override
    public void applyProjectOperations(Collection<IProjectEngineOperation> operations, IProjectEngineOperationHandler operationHandler, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        operationHandler.load();
        subMonitor.newChild(1);
        this.queueProjectOperations(operations, operationHandler, (IProgressMonitor)subMonitor.newChild(3));
        if (subMonitor.isCanceled()) {
            return;
        }
        operationHandler.commit();
        subMonitor.newChild(1);
    }

    @Override
    public void queueProjectOperations(Collection<IProjectEngineOperation> operations, IProjectEngineOperationHandler operationHandler, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)operations.size());
        StopWatch projectOpTimer = PerformanceManager.INSTANCE.logStartChild(LoggingFeature.ALL, "Project Model Engine running project operations");
        for (IProjectEngineOperation operation : operations) {
            StopWatch projectSingleOpTimer = PerformanceManager.INSTANCE.logStartChildMap(LoggingFeature.ALL, "Single Project Operation", () -> PerformanceMetadata.builder().put("operation", (Object)operation.toString()).build());
            try {
                operation.executeProcess(operationHandler, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CoreException e) {
                this.status.merge(Activator.reporter.newErrorStatus(e.getMessage(), (Throwable)e));
            }
            projectSingleOpTimer.done();
            if (!subMonitor.isCanceled()) continue;
            return;
        }
        projectOpTimer.done();
    }
}

