/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.templates;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.ImportModeUtils;
import com.silabs.ss.framework.project.api.core.templates.ProjectTemplateUtils;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.IWriteableTemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IModelDescriptorInternal;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryDescriptorUtils;
import com.silabs.ss.platform.api.sdk.core.ISDK;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;

public final class TemplateUtils {
    public static final String HWCONFIG_TEMPL_NAMESPACE = "projectModelHwconf";
    public static final String HWCONFIG_TEMPL_NAME = "hardwareConfiguratorProject";

    private TemplateUtils() {
    }

    public static void loadTemplateFile(List<ITemplateDescriptor> descs, ISDK sdk, StringBuilder errorTxt, IPath templatesFile) throws IOException {
        TemplateUtils.doLoadTemplateFile(descs, sdk == null ? null : (ISDKDescriptor)sdk.getDescriptor(), errorTxt, templatesFile);
    }

    public static void loadTemplateFile(List<ITemplateDescriptor> descs, ISDKDescriptor sdk, StringBuilder errorTxt, IPath templatesFile) throws IOException {
        TemplateUtils.doLoadTemplateFile(descs, sdk, errorTxt, templatesFile);
    }

    public static void loadTemplateFile(List<ITemplateDescriptor> descs, StringBuilder errorTxt, IPath templatesFile) throws IOException {
        TemplateUtils.doLoadTemplateFile(descs, null, errorTxt, templatesFile);
    }

    private static void doLoadTemplateFile(List<ITemplateDescriptor> descs, ISDKDescriptor sdk, StringBuilder errorTxt, IPath templatesFile) throws IOException {
        if (templatesFile == null || !templatesFile.toFile().isFile()) {
            return;
        }
        Collection detected = RegistryDescriptorUtils.loadDescriptorsFromFile(TemplateDescriptor.class, (File)templatesFile.toFile(), (String)"template");
        String defaultNamespace = "projectTemplate";
        if (sdk != null && sdk.getPropertyAccess().isValueNonDefault(TemplateProperties.BASE_TEMPLATE_NAMESPACE)) {
            defaultNamespace = (String)sdk.getProperty(TemplateProperties.BASE_TEMPLATE_NAMESPACE);
        }
        for (ITemplateDescriptor template : detected) {
            IWriteableTemplateDescriptor writeable = (IWriteableTemplateDescriptor)template;
            if (sdk != null) {
                writeable.setProperty(SDKProperties.CONTRIBUTING_SDK, (Object)sdk.getId());
                writeable.setProperty(CoreProperties.PROVIDER_LABEL, (Object)((String)sdk.getProperty(SDKProperties.SIMPLE_LABEL_WITH_VERSION)));
            } else if (template.getProperty(SDKProperties.CONTRIBUTING_SDK) == null) {
                throw new IllegalStateException(MessageFormat.format("Template ''{0}'' lacks required property: {1}.", template.getName(), SDKProperties.CONTRIBUTING_SDK));
            }
            writeable.setProperty(CoreProperties.DETECTED, (Object)true);
            writeable.setProperty(CoreProperties.BUILTIN, (Object)true);
            ProjectTemplateUtils.setDefaults(writeable);
            if (sdk == null && !writeable.getPropertyAccess().isDefinedLocally(TemplateProperties.IMPORT_MODE_COMPATIBILITY)) {
                writeable.setProperty(TemplateProperties.IMPORT_MODE_COMPATIBILITY, (Object)ImportModeUtils.importModeCompatAllBut(ImportMode.IN_PLACE, ImportMode.LINK));
            }
            IPath basePath = templatesFile.removeLastSegments(1);
            String projectFilesProp = template.getPropertyAccess().getValueString(TemplateProperties.PROJECT_FILES);
            if (TextUtils.isEmpty((String)projectFilesProp)) {
                if (TextUtils.isEmpty((String)template.getNamespace()) || Objects.equals(defaultNamespace, template.getNamespace())) {
                    throw new IllegalStateException("Template project file(s) not specified: " + template.getLabel());
                }
                writeable.setId(TemplateUtils.createUniqueId(writeable.getId(), templatesFile.toString()));
                descs.add((ITemplateDescriptor)writeable);
            } else {
                TemplateUtils.createForEachPath(sdk, template, basePath, projectFilesProp.split(","), defaultNamespace, descs, errorTxt);
            }
            DescriptorUtils.updatePathProperties((IWriteableDescriptor)writeable, (IPath)basePath, (String[])new String[]{"projectURIs", "projectFilePaths"});
        }
    }

    private static void createForEachPath(ISDKDescriptor sdk, ITemplateDescriptor template, IPath basePath, String[] projectFiles, String defaultNamespace, List<ITemplateDescriptor> descs, StringBuilder errorTxt) {
        IWriteableTemplateDescriptor writeable = (IWriteableTemplateDescriptor)template;
        ArrayList<URI> projectURIs = new ArrayList<URI>();
        String[] stringArray = projectFiles;
        int n = projectFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String projFile = stringArray[n2];
            projectURIs.add(TemplateUtils.getTemplateURI(sdk, basePath, projFile, template, errorTxt));
            ++n2;
        }
        writeable.setProperty(TemplateProperties.PROJECT_URIS, projectURIs);
        String oldName = writeable.getName();
        String id = TemplateUtils.getIdAndHandleTemplatizing(writeable, projectFiles[0], oldName, sdk == null ? null : sdk.getId());
        writeable.setId(id);
        if (TextUtils.isEmpty((String)oldName)) {
            writeable.setName(id);
        }
        if (!writeable.getPropertyAccess().isValueNonDefault(TemplateProperties.NAMESPACE)) {
            writeable.setProperty(TemplateProperties.NAMESPACE, (Object)defaultNamespace);
        }
        descs.add((ITemplateDescriptor)writeable);
    }

    private static URI getTemplateURI(ISDKDescriptor sdk, IPath basePath, String projectFile, ITemplateDescriptor template, StringBuilder errorTxt) {
        projectFile = projectFile.replace("%20", " ");
        URI installationURI = null;
        if (sdk != null) {
            File filePath = basePath.append(projectFile).toFile();
            if (!RuntimeUtils.isJUnitRunning() && !filePath.exists()) {
                if (!RuntimeUtils.isPlatformPDELaunch()) {
                    errorTxt.append("Template project file not found: ").append(filePath.getAbsolutePath()).append("\n");
                }
                return null;
            }
            installationURI = filePath.toURI();
        } else if (new File(projectFile).isAbsolute()) {
            try {
                installationURI = new URI(projectFile);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalStateException(MessageFormat.format("Template ''{0}'' has invalid URI for project file path: {1}", template.getName(), projectFile));
            }
        } else {
            installationURI = basePath.append(projectFile).toFile().toURI();
        }
        return installationURI;
    }

    private static String getIdAndHandleTemplatizing(IWriteableTemplateDescriptor writeable, String projectFile, String oldName, String sdkId) {
        Object extendedName;
        String baseName;
        String type = writeable.getPropertyAccess().getValueString(TemplateProperties.TYPE);
        if ("template".equals(type)) {
            if (TextUtils.isEmpty((String)oldName)) {
                throw new IllegalStateException("Examples with type=template must have a name set! " + writeable.getLabel());
            }
            baseName = sdkId;
            extendedName = oldName;
            if (HWCONFIG_TEMPL_NAME.equals(extendedName)) {
                writeable.setProperty(TemplateProperties.NAMESPACE, (Object)HWCONFIG_TEMPL_NAMESPACE);
            }
            writeable.setProperty(TemplateProperties.COPY_ORIGINAL_CONTENT, (Object)false);
            writeable.setProperty(CoreProperties.HIDDEN, (Object)false);
            ProjectTemplateUtils.correctLabels(writeable);
        } else {
            String id;
            baseName = sdkId != null ? sdkId : "compatibleSDK";
            extendedName = projectFile;
            if (writeable instanceof IModelDescriptorInternal && TextUtils.hasContent((String)(id = ((IModelDescriptorInternal)writeable).getModel().getId()))) {
                extendedName = id + "." + (String)extendedName;
            }
            writeable.setProperty(TemplateProperties.COPY_ORIGINAL_CONTENT, (Object)true);
        }
        return TemplateUtils.createUniqueId(baseName, (String)extendedName);
    }

    private static String createUniqueId(String sdkId, String path) {
        StringBuilder id = new StringBuilder(sdkId).append(".").append(path.replace(":", "-"));
        return id.toString();
    }
}

