/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.ImportSolutionProjectRecord;
import com.silabs.ss.framework.project.api.core.external.SolutionImportResult;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.migrate.ProjectFeatureMigrator;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.api.core.solution.SolutionFactory;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionSettings;
import com.silabs.ss.framework.project.api.core.solution.model.util.manual.SolutionModelLoading;
import com.silabs.ss.framework.project.internal.core.Activator;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class SlsProjExternalProjectImporter
extends BaseExternalProjectImporter {
    private static final String SOLUTION_EXT = ".solution";
    private static final String SLSPROJ_EXT = ".slsproj";

    public SlsProjExternalProjectImporter(String superTypeId) {
        super(superTypeId);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ImportProjectRecord[] findProjects(File projectLocation) {
        block3: {
            slsProjFiles = projectLocation.listFiles((FilenameFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;Ljava/lang/String;)Z, lambda$0(java.io.File java.lang.String ), (Ljava/io/File;Ljava/lang/String;)Z)());
            projectRecordsList = new ArrayList<ImportProjectRecord>();
            if (slsProjFiles == null) break block3;
            var7_4 = slsProjFiles;
            var6_5 = slsProjFiles.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                block4: {
                    file = var7_4[var5_6];
                    projName = FileUtils.removeFileExtension((File)file).getName();
                    fileName = file.getName().toLowerCase(Locale.ROOT);
                    if (!fileName.endsWith(".slsproj")) break block4;
                    record = new ImportProjectRecord(projName, file);
                    ** GOTO lbl19
                }
                if (!fileName.endsWith(".solution")) {
                    Activator.reporter.logError("Unknown extension type for " + String.valueOf(file));
                } else {
                    record = new ImportSolutionProjectRecord(projName, file);
lbl19:
                    // 2 sources

                    projectRecordsList.add(record);
                }
                ++var5_6;
            }
        }
        return (ImportProjectRecord[])projectRecordsList.toArray((IntFunction<ImportProjectRecord[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$1(int ), (I)[Lcom/silabs/ss/framework/project/api/core/external/ImportProjectRecord;)());
    }

    @Override
    public SolutionImportResult solutionProjectLocations(IImportSolutionDescriptor importDesc, IProgressMonitor monitor) throws CoreException {
        List<MSolution> solutions = this.loadSolution(importDesc);
        if (solutions == null) {
            return null;
        }
        SolutionImportResult.Builder builder = new SolutionImportResult.Builder();
        solutions.stream().map(MSolutionSettings::getProjects).flatMap(Collection::stream).map(p -> this.getProjectLocation(importDesc, (MSolutionProject)p)).filter(Objects::nonNull).forEach(builder::addLocation);
        return builder.build();
    }

    private File getProjectLocation(IImportSolutionDescriptor importDesc, MSolutionProject project) {
        String projLoc = project.getLocation();
        if (TextUtils.isEmpty((String)projLoc)) {
            projLoc = project.getName();
        }
        if (TextUtils.isEmpty((String)projLoc)) {
            return null;
        }
        File projFile = new File(importDesc.getInputLocation(), projLoc);
        if (projFile.isFile()) {
            return projFile;
        }
        return null;
    }

    @Override
    public MSolution createImportSolutionModel(IImportSolutionDescriptor importDesc, IProgressMonitor monitor) throws CoreException {
        List<MSolution> solutions = this.loadSolution(importDesc);
        if (solutions.isEmpty()) {
            return SolutionFactory.create(importDesc.getName()).createSolution();
        }
        return solutions.stream().filter(s -> Objects.equals(s.getName(), importDesc.getName())).findFirst().orElse(solutions.get(0));
    }

    private List<MSolution> loadSolution(IImportSolutionDescriptor importDesc) throws CoreException {
        List solutions;
        File root = importDesc.getInputLocation();
        if (!root.isFile()) {
            return Collections.emptyList();
        }
        try {
            solutions = SolutionModelLoading.loadMSolutionsFromFile((File)root);
        }
        catch (Exception e) {
            throw Activator.reporter.newCoreException("Failed to load solution file from " + String.valueOf(root), (Throwable)e);
        }
        return solutions;
    }

    @Override
    public MProject createImportModel(IImportProjectDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        MProject mproject = null;
        if (importDescr.getInputLocation().isFile()) {
            try {
                mproject = ProjectModelLoading.loadProjectModel((URI)importDescr.getInputLocation().toURI());
            }
            catch (Exception exception) {}
        }
        if (mproject == null) {
            mproject = ProjectModelFactory.eINSTANCE.createMProject();
            mproject.setContentRoot(importDescr.getInputLocation().getParentFile().toURI().toString());
        }
        new MigrateToV4Switch().doSwitch((EObject)mproject);
        return mproject;
    }

    private static /* synthetic */ boolean lambda$0(File d, String n) {
        String name = n.toLowerCase(Locale.ROOT);
        return name.endsWith(SLSPROJ_EXT) || name.endsWith(SOLUTION_EXT);
    }

    private static /* synthetic */ ImportProjectRecord[] lambda$1(int n) {
        return new ImportProjectRecord[n];
    }

    private class MigrateToV4Switch
    extends ProjectModelSwitch<Object> {
        private ProjectFeatureMigrator migrator = ProjectFeatureMigrator.instance();

        private MigrateToV4Switch() {
        }

        public Object caseMSelectable(MSelectable selectable) {
            String tcComapt;
            String sdkComapt;
            String partCompat = selectable.getPartCompatibility();
            if (!TextUtils.isEmpty((String)partCompat) && !partCompat.contains("com.silabs")) {
                return selectable;
            }
            String newPartComapt = this.migrator.migratePartId(partCompat);
            if (newPartComapt != null) {
                selectable.setPartCompatibility(newPartComapt);
            }
            if ((sdkComapt = this.migrator.migrateSdkId(selectable.getSdkCompatibility())) != null) {
                selectable.setSdkCompatibility(sdkComapt);
            }
            if ((tcComapt = this.migrator.migrateToolChainId(selectable.getToolchainCompatibility())) != null) {
                selectable.setToolchainCompatibility(tcComapt);
            }
            return null;
        }

        public Object caseMConfiguration(MConfiguration config) {
            if (config.getStockConfigCompatibility() != null) {
                String stockConfig = config.getStockConfigCompatibility().replace("com.silabs.ide.toolchain.core.", "com.silabs.ss.framework.project.toolchain.core.");
                config.setStockConfigCompatibility(stockConfig);
            }
            return null;
        }

        public Object defaultCase(EObject object) {
            for (EObject obj : object.eContents()) {
                this.doSwitch(obj);
            }
            return this;
        }
    }
}

