/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.creator.BaseProjectHandler;
import com.silabs.ss.framework.project.api.core.creator.IProjectHandler;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportProjectEngine;
import com.silabs.ss.framework.project.api.core.utils.ProjectUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.ImportAnalyticsData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ImportProjectHandler
extends BaseProjectHandler {
    private IProjectHandler existingProjectHandler;
    private IImportProjectEngine engine;
    private boolean createReport;

    public ImportProjectHandler(IImportProjectDescriptor projectDesc, IProjectHandler existingProjectHandler, IImportProjectEngine engine) {
        super(projectDesc, existingProjectHandler);
        this.existingProjectHandler = existingProjectHandler;
        this.engine = engine;
    }

    public void setCreateReport(boolean createReport) {
        this.createReport = createReport;
    }

    public boolean isCreateReport() {
        return this.createReport;
    }

    @Override
    public void setupProjectDescriptor(IWriteableProjectDescriptor projectDesc, IProgressMonitor monitor) throws CoreException {
        this.engine.setupImportDescriptor((IImportProjectDescriptor)projectDesc, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        this.existingProjectHandler.setupProjectDescriptor(projectDesc, monitor);
    }

    @Override
    public void createOrConvertProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        boolean isImportProjectDescriptor = this.projectDesc instanceof IImportProjectDescriptor;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Importing " + this.projectDesc.getName() + "..."), (int)10);
        if (!isImportProjectDescriptor || !ProjectUtils.isSlsArchiveProjectType(((IImportProjectDescriptor)this.projectDesc).getExternalProjectType())) {
            this.setupProjectDescriptor(this.projectDesc, (IProgressMonitor)subMonitor.newChild(8));
        }
        this.existingProjectHandler.createOrConvertProject((IProgressMonitor)subMonitor.newChild(1));
        if (this.createReport && isImportProjectDescriptor) {
            try {
                this.engine.writeImportReport((IImportProjectDescriptor)this.projectDesc);
            }
            catch (CoreException e) {
                Activator.reporter.logError("failed to write import report", (Throwable)e);
            }
        }
        this.existingProjectHandler.finalizeProject(this.projectDesc, (IProgressMonitor)subMonitor.newChild(1));
        if (isImportProjectDescriptor) {
            ImportAnalyticsData.logBuild((IImportProjectDescriptor)this.projectDesc);
        }
    }
}

