/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine.operations;

import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseLanguageAwareProjectSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddLibrarySettingOperation;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.internal.core.Activator;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddLibraryPathSettingOperation
extends BaseLanguageAwareProjectSettingOperation
implements IAddLibrarySettingOperation {
    private URI libURI;

    public AddLibraryPathSettingOperation(IProjectEngineSession session, String buildConfig, MLibraryPath path) {
        super(session, buildConfig, null, (MBuildSetting)path);
        try {
            this.libURI = session.getProjectModel().resolveURI(path.getUri(), true);
            this.libURI = session.getProjectModel().encodeProjectURI(this.libURI);
        }
        catch (IllegalArgumentException e) {
            Activator.reporter.logError("invalid library path: " + path.getUri(), (Throwable)e);
            this.libURI = URI.create("");
        }
    }

    @Override
    public final void executeProcess(IProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        if (this.libURI != null) {
            handler.handleAddLibraryPathSettingOperation(this, monitor);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": <" + String.valueOf(this.libURI) + ">";
    }

    @Override
    public String getBuildConfiguration() {
        return this.buildConfig;
    }

    @Override
    public URI getLibraryURI() {
        return this.libURI;
    }
}

