/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import org.eclipse.core.runtime.IPath;

public class ProjectModelObjectUtils {
    public static final String ASM_AND_C_AND_CPP = String.valueOf(ELanguage.ASM) + " " + String.valueOf(ELanguage.C) + " " + String.valueOf(ELanguage.CPP);
    public static final String C_AND_CPP = String.valueOf(ELanguage.C) + " " + String.valueOf(ELanguage.CPP);

    private ProjectModelObjectUtils() {
    }

    public static MIncludePath createAllLanguageIncludePath(IPath path) {
        return ProjectModelObjectUtils.createSpecifiedLanguageIncludePath(path, ASM_AND_C_AND_CPP);
    }

    public static MIncludePath createSpecifiedLanguageIncludePath(IPath path, String compatibility) {
        MIncludePath incl = ProjectModelFactory.eINSTANCE.createMIncludePath();
        incl.setUri(path.toPortableString());
        incl.setLanguageCompatibility(ASM_AND_C_AND_CPP);
        incl.setBuiltin(true);
        return incl;
    }

    public static MMacroDefinition createAllLanguageMacroDefinition(String name, String value) {
        return ProjectModelObjectUtils.createSpecifiedLanguageMacroDefinition(name, value, ASM_AND_C_AND_CPP);
    }

    public static MMacroDefinition createSpecifiedLanguageMacroDefinition(String name, String value, String compatibility) {
        MMacroDefinition def = ProjectModelFactory.eINSTANCE.createMMacroDefinition();
        def.setName(name);
        def.setValue(value);
        def.setLanguageCompatibility(compatibility);
        def.setBuiltin(true);
        return def;
    }
}

