/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.model.MModule;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class ModuleReference
implements IModuleReference {
    private MModule module;
    private boolean isRemoved;
    private Set<String> builtinSources = new LinkedHashSet<String>();
    private Set<String> builtinExcludes = new LinkedHashSet<String>();

    public ModuleReference() {
    }

    public ModuleReference(MModule module) {
        this.setModule(module);
    }

    @Override
    public String getId() {
        return this.module.getId();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.module.getId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleReference other = (ModuleReference)obj;
        return this.module.getId().equals(other.module.getId());
    }

    public String toString() {
        return "ModuleReference [moduleId=" + this.getId() + ", isRemoved=" + this.isRemoved + ", builtinSources=" + String.valueOf(this.builtinSources) + ", builtinExcludes=" + String.valueOf(this.builtinExcludes) + "]";
    }

    @Override
    public MModule getModule() {
        return this.module;
    }

    @Override
    public Collection<String> getBuiltinSources() {
        return this.builtinSources;
    }

    @Override
    public Collection<String> getBuiltinExcludes() {
        return this.builtinExcludes;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setModule(MModule module) {
        if (module == null) {
            throw new IllegalArgumentException();
        }
        this.module = module;
    }

    public void setBuiltinSources(Collection<String> builtinSources) {
        this.builtinSources.clear();
        if (builtinSources != null) {
            this.builtinSources.addAll(builtinSources);
        }
    }

    public void setBuiltinExcludes(Collection<String> builtinExcludes) {
        this.builtinExcludes.clear();
        if (builtinExcludes != null) {
            this.builtinExcludes.addAll(builtinExcludes);
        }
    }

    public boolean isBuiltin() {
        return this.module.isBuiltin();
    }

    public void setBuiltin(boolean builtIn) {
    }
}

