/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.hash.FileContentHashing;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.GenerateProjectFileOperation;
import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;

public class CopiedFileReference
implements ICopiedFileReference {
    @Deprecated
    public static final String TRASH_FOLDER = ".trash";
    private static final String MODIFIED_TRASH_OBVIOUS = "trashed_modified_files";
    private String projectPath;
    private boolean isGenerated;
    private int content;
    private int version;

    public CopiedFileReference() {
    }

    public CopiedFileReference(CopyProjectFileOperation op) {
        this(op.getProjectPath(), false, op.getContentFile().toString(), CopiedFileReference.calculateContent(op.getContentFile(), FileContentHashing.latestVersion()));
    }

    public CopiedFileReference(GenerateProjectFileOperation op) {
        this(op.getProjectPath(), true, null, CopiedFileReference.calculateContent(op.getFileContent(), FileContentHashing.latestVersion()));
    }

    private CopiedFileReference(IPath prjPath, boolean isGenerated, String originalPath, int content) {
        this.projectPath = ICopiedFileReference.getProjectPath(prjPath);
        this.isGenerated = isGenerated;
        this.content = content;
        this.version = FileContentHashing.latestVersion();
    }

    @Override
    public boolean isSameContent(File expectedFile) {
        if (expectedFile == null || !expectedFile.isFile()) {
            return false;
        }
        int hash = CopiedFileReference.calculateContent(expectedFile, this.version);
        return hash == this.getContent();
    }

    private static int calculateContent(File contentFile, int version) {
        return FileContentHashing.hasher(version).calculateContent(contentFile);
    }

    private static int calculateContent(String contents, int version) {
        return FileContentHashing.hasher(version).calculateContent(contents);
    }

    @Override
    public String trashPath() {
        return Paths.get(CopiedFileReference.getTrashFolderName(), new String[0]).resolve(this.projectPath).toString();
    }

    public static String getPreviousTrashFolderName() {
        return TRASH_FOLDER;
    }

    public static String getTrashFolderName() {
        return MODIFIED_TRASH_OBVIOUS;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public int getContent() {
        return this.content;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return "CopiedFileReference [projectPath=" + this.projectPath + ", isGenerated=" + this.isGenerated + ", contentHash=" + this.content + "]";
    }

    public int hashCode() {
        return Objects.hash(this.projectPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICopiedFileReference)) {
            return false;
        }
        ICopiedFileReference other = (ICopiedFileReference)obj;
        return Objects.equals(this.projectPath, other.getProjectPath());
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public void setContent(int content) {
        this.content = content;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getOriginalPath() {
        return "";
    }

    public void setOriginalPath(String originalPath) {
    }
}

