/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.AddIncludePathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryFileSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryPathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddMacroDefinitionSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectResourceFilterOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddSourceFolderToConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.GenerateProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IConfigurationScopeEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEntryEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IRemoveFromProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IncludeResourceIntoConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.RemoveProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ReportErrorOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ResetModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationOutputBaseNameOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPrebuildStepOperation;
import com.silabs.ss.framework.project.api.core.model.IResourceFilterInfo;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public abstract class BaseProjectEngineOperationFactory
implements IProjectEngineOperationFactory {
    @Override
    public IProjectEngineOperation createReportErrorOperation(IProjectEngineSession session, MEntry entry, File contentFile, IOException e) {
        return new ReportErrorOperation(session, entry, contentFile, e);
    }

    @Override
    public IProjectEntryEngineOperation createAddProjectResourceFilterOperation(IProjectEngineSession session, IPath projectPath, IResourceFilterInfo filterInfo) {
        return new AddProjectResourceFilterOperation(session, projectPath, filterInfo);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddSourceFolderOperation(IProjectEngineSession session, String configId, IPath projectPath) {
        return new AddSourceFolderToConfigurationOperation(session, configId, projectPath);
    }

    @Override
    public IConfigurationScopeEngineOperation createExcludeResourceFromConfigurationOperation(IProjectEngineSession session, String buildConfig, IPath projectPath, URI contentURI) {
        return new ExcludeResourceFromConfigurationOperation(session, buildConfig, projectPath, contentURI);
    }

    @Override
    public IConfigurationScopeEngineOperation createIncludeResourceIntoConfigurationOperation(IProjectEngineSession session, String configId, IPath projectPath, URI contentURI) {
        return new IncludeResourceIntoConfigurationOperation(session, configId, projectPath, contentURI);
    }

    @Override
    public IConfigurationScopeEngineOperation createSetConfigurationOutputBaseNameOperation(IProjectEngineSession session, String configId, String outputName) {
        return new SetConfigurationOutputBaseNameOperation(session, configId, outputName);
    }

    @Override
    public IConfigurationScopeEngineOperation createSetConfigurationPrebuildStepOperation(IProjectEngineSession session, String configId, String prebuildStep) {
        return new SetConfigurationPrebuildStepOperation(session, configId, prebuildStep);
    }

    @Override
    public IConfigurationScopeEngineOperation createSetConfigurationPostbuildStepOperation(IProjectEngineSession session, String configId, String postbuildStep) {
        return new SetConfigurationPostbuildStepOperation(session, configId, postbuildStep);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddIncludePathSettingOperation(IProjectEngineSession session, String configId, MIncludePath path, IPath projectPath) {
        return new AddIncludePathSettingOperation(session, configId, path, projectPath);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddMacroDefinitionSettingOperation(IProjectEngineSession session, String configId, MMacroDefinition def, IPath projectPath) {
        return new AddMacroDefinitionSettingOperation(session, configId, def, projectPath);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddToolOptionOperation(IProjectEngineSession session, String configId, MToolOption option, List<MToolListOption> listOptions, IPath projectPath) {
        return new AddToolOptionOperation(session, configId, option, listOptions, projectPath);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddLibraryPathOperation(IProjectEngineSession session, String configId, MLibraryPath path) {
        return new AddLibraryPathSettingOperation(session, configId, path);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddLibraryFileOperation(IProjectEngineSession session, String configId, MLibraryFile file) {
        return new AddLibraryFileSettingOperation(session, configId, file);
    }

    @Override
    public IConfigurationScopeEngineOperation createResetModuleReferencesOperation(IProjectEngineSession session, String configId) {
        return new ResetModuleReferencesOperation(session, configId);
    }

    @Override
    public IConfigurationScopeEngineOperation createAddModuleReferenceOperation(IProjectEngineSession session, String configId, IModuleReference moduleReference) {
        return new AddModuleReferenceOperation(session, configId, moduleReference);
    }

    @Override
    public IProjectEngineOperation createAddProjectDefinedModuleOperation(IProjectEngineSession session, MProject moduleDefinition) {
        return new AddProjectDefinedModuleOperation(session, moduleDefinition);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFileOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFile, MFileEntry entry, MSelectable selector) throws IOException {
        if (entry != null && entry.isGenerated()) {
            if (TextUtils.isEmpty((String)entry.getFileContent()) && contentFile != null && contentFile.isFile()) {
                return new CopyProjectFileOperation(session, projectPath, contentFile, entry, selector);
            }
            return new GenerateProjectFileOperation(session, projectPath, contentFile, entry, selector);
        }
        return null;
    }

    @Override
    public IRemoveFromProjectEngineOperation createRemoveProjectFileOperation(IProjectEngineSession session, IPath projectPath) {
        return new RemoveProjectFileOperation(session, projectPath);
    }

    @Override
    public IRemoveFromProjectEngineOperation createRemoveProjectFolderOperation(IProjectEngineSession session, IPath projectPath) {
        return new RemoveProjectFolderOperation(session, projectPath);
    }
}

