/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.creator;

import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.INewProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectAnalytics;
import com.silabs.ss.framework.project.api.core.creator.IProjectHandler;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.templates.IProjectModelTemplateContext;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class BaseProjectHandler
implements IProjectHandler,
IProjectModelTemplateContext {
    protected IWriteableProjectDescriptor projectDesc;
    private Map<String, String> varMap;
    private Map<String, Object> objectMap;

    public BaseProjectHandler(IWriteableProjectDescriptor projectDesc) {
        this(projectDesc, null);
    }

    protected BaseProjectHandler(IWriteableProjectDescriptor projectDesc, IProjectHandler wrapper) {
        if (projectDesc == null) {
            throw new NullPointerException();
        }
        this.projectDesc = projectDesc;
        if (!(wrapper instanceof BaseProjectHandler)) {
            ProjectAnalytics.logNewProject(projectDesc);
        }
    }

    @Override
    public IWriteableProjectDescriptor getProjectDescriptor() {
        return this.projectDesc;
    }

    @Override
    public IProjectEntity getProjectEntity() {
        return null;
    }

    public Map<String, String> getVariableMap() {
        if (this.varMap == null) {
            this.varMap = new HashMap<String, String>();
        }
        return this.varMap;
    }

    public Map<String, Object> getObjectMap() {
        if (this.objectMap == null) {
            this.objectMap = new HashMap<String, Object>();
        }
        return this.objectMap;
    }

    @Override
    public IPath getInitiallyOpenedResource() {
        if (!(this.projectDesc instanceof INewProjectDescriptor)) {
            return null;
        }
        ITemplate templ = ((INewProjectDescriptor)this.projectDesc).getTemplate();
        if (templ == null) {
            return null;
        }
        String path = (String)templ.getProperty(TemplateProperties.INITIALLY_OPENED_RESOURCE);
        if (path.isEmpty()) {
            return null;
        }
        if (this.projectDesc instanceof INewProjectDescriptor) {
            path = new VariableSubstitutionEngine('(').substitute(path, (IVariableLookup)new MapVariableLookup(this.getVariableMap()));
        }
        return new Path(path);
    }

    @Override
    public void setupProjectDescriptor(IWriteableProjectDescriptor projectDesc, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void finalizeProject(IWriteableProjectDescriptor projectDesc, IProgressMonitor monitor) throws CoreException {
        ProjectAnalytics.logNewProject(projectDesc);
    }
}

