/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.builtin;

import com.google.common.collect.Multimap;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInState;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.IResolvedToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.ToolOption;
import com.silabs.ss.platform.api.descriptor.core.type.TypeReference;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProjectBuiltInHandler {
    public static final TypeReference<Collection<ProjectBuiltInState>> CPP_BUILTIN_IN_STATE_LIST = TypeReference.create((String)"projectBuiltInStateList", Collection.class);
    private static final String NORMALIZED_NULL = "%null%";
    private ProjectBuiltInState state;
    private Multimap<String, String> toolOptReplacements;

    public ProjectBuiltInHandler(ProjectBuiltInState state) {
        this.state = state;
    }

    public void resetResourceBuiltins() {
        this.state.resetResourceBuiltins();
    }

    public boolean isMacroBuiltin(String name, String value) {
        if (TextUtils.isEmpty((String)value)) {
            value = NORMALIZED_NULL;
        }
        return Objects.equals(value, this.state.macrosMap().get(name));
    }

    public void addMacro(String name, String value) {
        if (TextUtils.isEmpty((String)value)) {
            value = NORMALIZED_NULL;
        }
        this.state.macrosMap().put(name, value);
    }

    public boolean isIncludeBuiltin(String uri) {
        return this.isIncludeBuiltin(this.getUri(uri));
    }

    public boolean isIncludeBuiltin(URI uri) {
        return this.state.includes().contains(uri);
    }

    public void addInclude(URI uri) {
        this.state.includes().add(uri);
    }

    public boolean isLibraryFileUriBuiltin(String uri) {
        return this.isLibraryFileBuiltin(this.getUri(uri));
    }

    public boolean isLibraryFileBuiltin(URI uri) {
        return this.state.libraryFiles().contains(uri);
    }

    public void addLibraryFile(URI uri) {
        this.state.libraryFiles().add(uri);
    }

    public boolean isLibraryFileBuiltin(String name) {
        return this.state.libraryNames().contains(name);
    }

    public void addLibraryFile(String name) {
        this.state.libraryNames().add(name);
    }

    public boolean isLibraryPathBuiltin(String uri) {
        return this.isLibraryPathBuiltin(this.getUri(uri));
    }

    public boolean isLibraryPathBuiltin(URI uri) {
        return this.state.libraryPaths().contains(uri);
    }

    public boolean addLibraryPath(URI uri) {
        return this.state.libraryPaths().add(uri);
    }

    public boolean isLibraryObjectBuiltin(String uri) {
        return this.isLibraryObjectBuiltin(this.getUri(uri));
    }

    public boolean isLibraryObjectBuiltin(URI uri) {
        return this.state.libraryObjects().contains(uri);
    }

    public boolean addLibraryObject(URI uri) {
        return this.state.libraryObjects().add(uri);
    }

    private URI getUri(String uriStr) {
        if (TextUtils.isEmpty((String)uriStr)) {
            return null;
        }
        return URI.create(uriStr);
    }

    public void updateBuiltinState(ToolOption opt) {
        this.doUpdateBuiltinState(opt);
    }

    public void updateBuiltinState(MToolOption opt) {
        this.doUpdateBuiltinState(opt);
    }

    public ProjectBuiltInHandler setToolOptionReplacements(Multimap<String, String> toolOptReplacements) {
        this.toolOptReplacements = toolOptReplacements;
        return this;
    }

    protected void doUpdateBuiltinState(Object opt) {
        List matchingOpts = this.state.resolvedOptions().stream().filter(t -> this.areSame(opt, (IResolvedToolOption)t)).collect(Collectors.toList());
        boolean builtin = false;
        if (!matchingOpts.isEmpty() && this.allListOptsBuiltin(opt)) {
            builtin = matchingOpts.stream().allMatch(IResolvedToolOption::isBuiltin);
        }
        this.setBuiltin(opt, builtin);
    }

    private boolean areSame(Object real, IResolvedToolOption testBuiltin) {
        if (!Objects.equals(this.optionId(real), testBuiltin.getOptionId()) || !Objects.equals(this.toolId(real), testBuiltin.getToolId())) {
            return false;
        }
        String realValue = this.getValue(real);
        String testValue = testBuiltin.getValue();
        if (TextUtils.hasContent((String)realValue) && TextUtils.hasContent((String)testValue)) {
            if (Objects.equals(realValue, testValue)) {
                return true;
            }
            if (this.toolOptReplacements == null) {
                return false;
            }
            return this.toolOptReplacements.entries().stream().map(e -> realValue.replace((CharSequence)e.getKey(), (CharSequence)e.getValue())).anyMatch(testValue::equals);
        }
        if (real instanceof MToolOption) {
            ((MToolOption)real).getToolListOptions().forEach(tl -> tl.setBuiltin(testBuiltin.isListValueBuiltin(tl.getValue())));
        } else if (real instanceof ToolOption) {
            ((ToolOption)real).getListValues().forEach(rl -> ((ToolOption)real).setListValueBuiltin(rl, testBuiltin.isListValueBuiltin(rl)));
        }
        return true;
    }

    private String optionId(Object opt) {
        if (opt instanceof MToolOption) {
            return ((MToolOption)opt).getOptionId();
        }
        if (opt instanceof ToolOption) {
            return ((ToolOption)opt).getOptionId();
        }
        return "";
    }

    private String toolId(Object opt) {
        if (opt instanceof MToolOption) {
            return ((MToolOption)opt).getToolId();
        }
        if (opt instanceof ToolOption) {
            return ((ToolOption)opt).getToolId();
        }
        return "";
    }

    private String getValue(Object opt) {
        if (opt instanceof MToolOption) {
            return ((MToolOption)opt).getValue();
        }
        if (opt instanceof ToolOption) {
            return ((ToolOption)opt).getValue();
        }
        return "";
    }

    private boolean allListOptsBuiltin(Object opt) {
        if (opt instanceof MToolOption) {
            return ((MToolOption)opt).getToolListOptions().stream().allMatch(MSelectable::isBuiltin);
        }
        if (opt instanceof ToolOption) {
            return ((ToolOption)opt).getListValues().stream().allMatch(s -> ((ToolOption)opt).isListValueBuiltin(s));
        }
        return false;
    }

    protected void setBuiltin(Object opt, boolean builtin) {
        if (opt instanceof MToolOption) {
            ((MToolOption)opt).setBuiltin(builtin);
        } else if (opt instanceof ToolOption) {
            ((ToolOption)opt).setBuiltin(builtin);
        }
    }

    public void addToolOption(IResolvedToolOption option) {
        if (!(option instanceof ToolOption)) {
            throw new IllegalArgumentException("All IToolOptions should be ToolOptions!");
        }
        ToolOption opt = (ToolOption)option;
        if (!opt.isBuiltin()) {
            if (!opt.getListValues().stream().anyMatch(arg_0 -> ((ToolOption)opt).isListValueBuiltin(arg_0))) {
                return;
            }
        }
        this.state.resolvedOptions().add(option);
    }

    public void removeToolOption(IResolvedToolOption option) {
        this.state.resolvedOptions().removeIf(o -> Objects.equals(o.getToolId(), option.getToolId()) && Objects.equals(o.getOptionId(), option.getOptionId()));
    }
}

