/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.testing.assertj.AutoValue_AttributeAssertion;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

@AutoValue
public abstract class AttributeAssertion {
    static AttributeAssertion create(AttributeKey<?> key, Consumer<? extends AbstractAssert<?, ?>> assertion) {
        return new AutoValue_AttributeAssertion(key, assertion);
    }

    abstract AttributeKey<?> getKey();

    abstract Consumer<AbstractAssert<?, ?>> getAssertion();

    static AbstractAssert<?, ?> attributeValueAssertion(AttributeKey<?> key, @Nullable Object value) {
        AbstractAssert<? extends AbstractAssert<?, ?>, ?> abstractAssert = AttributeAssertion.makeAssertion(key, value);
        String description = "%s attribute '%s'";
        return (AbstractAssert)abstractAssert.as(description, new Object[]{key.getType(), key.getKey()});
    }

    private static AbstractAssert<? extends AbstractAssert<?, ?>, ?> makeAssertion(AttributeKey<?> key, Object value) {
        switch (key.getType()) {
            case STRING: {
                return Assertions.assertThat((String)((String)value));
            }
            case BOOLEAN: {
                return Assertions.assertThat((Boolean)((Boolean)value));
            }
            case LONG: {
                return Assertions.assertThat((Long)((Long)value));
            }
            case DOUBLE: {
                return Assertions.assertThat((Double)((Double)value));
            }
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                return Assertions.assertThat((List)((List)value));
            }
        }
        throw new IllegalArgumentException("Unknown type for key " + key);
    }

    AttributeAssertion() {
    }
}

